/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.tools.compare;

import org.apache.poi.ss.usermodel.Workbook;
import org.spdx.library.InvalidSPDXAnalysisException;
import org.spdx.library.model.SpdxFile;
import org.spdx.tools.compare.AbstractFileCompareSheet;
import org.spdx.utility.compare.SpdxCompareException;
import org.spdx.utility.compare.SpdxComparer;

public class FileCopyrightSheet
extends AbstractFileCompareSheet {
    static final int COPYRIGHT_COL_WIDTH = 60;

    public FileCopyrightSheet(Workbook workbook, String sheetName) {
        super(workbook, sheetName);
    }

    static void create(Workbook wb, String sheetName) {
        AbstractFileCompareSheet.create(wb, sheetName, 60);
    }

    @Override
    boolean valuesMatch(SpdxComparer comparer, SpdxFile fileA, int docIndexA, SpdxFile fileB, int docIndexB) throws SpdxCompareException, InvalidSPDXAnalysisException {
        return SpdxComparer.stringsEqual((String)fileA.getCopyrightText(), (String)fileB.getCopyrightText());
    }

    @Override
    String getFileValue(SpdxFile spdxFile) throws InvalidSPDXAnalysisException {
        String retval = spdxFile.getCopyrightText();
        if (retval == null) {
            retval = "NONE";
        }
        return retval;
    }
}

