/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.tools.compare;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spdx.library.InvalidSPDXAnalysisException;
import org.spdx.library.model.SpdxFile;
import org.spdx.spreadsheetstore.SpreadsheetException;
import org.spdx.tools.compare.CreatorSheet;
import org.spdx.tools.compare.DocumentAnnotationSheet;
import org.spdx.tools.compare.DocumentRelationshipSheet;
import org.spdx.tools.compare.DocumentSheet;
import org.spdx.tools.compare.ExternalReferencesSheet;
import org.spdx.tools.compare.ExtractedLicenseSheet;
import org.spdx.tools.compare.FileAnnotationSheet;
import org.spdx.tools.compare.FileAttributionSheet;
import org.spdx.tools.compare.FileChecksumSheet;
import org.spdx.tools.compare.FileCommentSheet;
import org.spdx.tools.compare.FileConcludedSheet;
import org.spdx.tools.compare.FileContributorsSheet;
import org.spdx.tools.compare.FileCopyrightSheet;
import org.spdx.tools.compare.FileLicenseCommentsSheet;
import org.spdx.tools.compare.FileLicenseInfoSheet;
import org.spdx.tools.compare.FileNoticeSheet;
import org.spdx.tools.compare.FileRelationshipSheet;
import org.spdx.tools.compare.FileSpdxIdSheet;
import org.spdx.tools.compare.FileTypeSheet;
import org.spdx.tools.compare.NormalizedFileNameComparator;
import org.spdx.tools.compare.PackageSheet;
import org.spdx.tools.compare.SnippetSheet;
import org.spdx.tools.compare.VerificationSheet;
import org.spdx.utility.compare.SpdxCompareException;
import org.spdx.utility.compare.SpdxComparer;

public class MultiDocumentSpreadsheet {
    protected File saveFile;
    protected Workbook workbook;
    private boolean readonly;
    private SpdxFileComparator fileComparator = new SpdxFileComparator();
    static Logger logger = LoggerFactory.getLogger(MultiDocumentSpreadsheet.class);
    protected static final String DOCUMENT_SHEET_NAME = "Document";
    protected DocumentSheet documentSheet;
    protected static final String CREATOR_SHEET_NAME = "Creator";
    protected CreatorSheet creatorSheet;
    protected static final String PACKAGE_SHEET_NAME = "Package";
    protected PackageSheet packageSheet;
    protected static final String EXTRACTED_LICENSE_SHEET_NAME = "Extracted Licenses";
    protected ExtractedLicenseSheet extractedLicenseSheet;
    protected static final String FILE_CHECKSUM_SHEET_NAME = "File Checksum";
    protected FileChecksumSheet fileChecksumSheet;
    protected static final String FILE_CONCLUDED_SHEET_NAME = "File Concluded";
    protected FileConcludedSheet fileConcludedSheet;
    protected static final String FILE_FOUND_SHEET_NAME = "File Found Licenses";
    protected FileLicenseInfoSheet fileLicenseInfoSheet;
    protected static final String FILE_LICENSE_COMMENT_SHEET_NAME = "File License Comment";
    protected FileLicenseCommentsSheet fileLicenseCommentsSheet;
    protected static final String FILE_COMMENT_SHEET_NAME = "File Comment";
    protected FileCommentSheet fileCommentSheet;
    protected static final String FILE_TYPE_SHEET_NAME = "File Type";
    protected FileTypeSheet fileTypeSheet;
    protected static final String FILE_CONTRIBUTOR_SHEET_NAME = "File Contributors";
    protected FileContributorsSheet fileContributorsSheet;
    protected static final String FILE_ATTRIBUTION_SHEET_NAME = "File Attribution";
    protected FileAttributionSheet fileAttributionSheet;
    protected static final String FILE_NOTICE_SHEET_NAME = "File Notices";
    protected FileNoticeSheet fileNoticeSheet;
    protected static final String VERIFICATION_SHEET_NAME = "Verification Errors";
    public static final int MAX_DOCUMENTS = 25;
    protected static final String EXTERNAL_REFERENCES_SHEET_NAME = "Ext. Doc. References";
    protected static final String DOCUMENT_RELATIONSHIP_SHEET_NAME = "Doc. Relationships";
    protected static final String DOCUMENT_ANNOTATION_SHEET_NAME = "Doc. Annotations";
    protected static final String FILE_SPDX_ID_SHEET_NAME = "File IDs";
    protected static final String FILE_COPYRIGHT_SHEET_NAME = "File Copyrights";
    protected static final String FILE_ANNOTATION_SHEET_NAME = "File Annot.";
    protected static final String FILE_RELATIONSHIP_SHEET = "File Relationships";
    protected static final String SNIPPET_SHEET_NAME = "Snippets";
    protected VerificationSheet verificationSheet;
    protected ExternalReferencesSheet externalReferencesSheet;
    protected DocumentAnnotationSheet documentAnnotationSheet;
    protected DocumentRelationshipSheet documentRelationshipSheet;
    protected FileSpdxIdSheet fileSpdxIdSheet;
    protected FileCopyrightSheet fileCopyrightSheet;
    protected FileAnnotationSheet fileAnnotationSheet;
    protected FileRelationshipSheet fileRelationshipSheet;
    protected SnippetSheet snippetSheet;

    public MultiDocumentSpreadsheet(File spreadsheetFile, boolean create, boolean readonly) throws SpreadsheetException {
        this.readonly = readonly;
        if (readonly && create) {
            throw new SpreadsheetException("Can not create a readonly spreadsheet");
        }
        if (!spreadsheetFile.exists()) {
            if (!create) {
                throw new SpreadsheetException("File " + spreadsheetFile.getName() + " does not exist");
            }
            try {
                this.create(spreadsheetFile);
            }
            catch (IOException ex) {
                logger.error("IO error creating spreadsheet: " + ex.getMessage());
                throw new SpreadsheetException("I/O error creating spreadsheet");
            }
        }
        this.saveFile = spreadsheetFile;
        FileInputStream input = null;
        try {
            input = new FileInputStream(spreadsheetFile);
            this.workbook = WorkbookFactory.create((InputStream)input);
        }
        catch (FileNotFoundException ex) {
            logger.error("Can not open Excel file.  File " + spreadsheetFile.getName() + " does not exist");
            throw new SpreadsheetException("Can not open Excel file.  File " + spreadsheetFile.getName() + " does not exist");
        }
        catch (IOException ex) {
            logger.error("IO Exception opening excel workbook: " + ex.getMessage());
            throw new SpreadsheetException("IO Exception opening excel workbook.  See log for more detail.");
        }
        finally {
            if (input != null) {
                try {
                    ((InputStream)input).close();
                }
                catch (IOException ex) {
                    logger.warn("IO Error closing excel file: " + ex.getMessage());
                }
            }
        }
        this.documentSheet = new DocumentSheet(this.workbook, DOCUMENT_SHEET_NAME);
        this.externalReferencesSheet = new ExternalReferencesSheet(this.workbook, EXTERNAL_REFERENCES_SHEET_NAME);
        this.creatorSheet = new CreatorSheet(this.workbook, CREATOR_SHEET_NAME);
        this.documentAnnotationSheet = new DocumentAnnotationSheet(this.workbook, DOCUMENT_ANNOTATION_SHEET_NAME);
        this.documentRelationshipSheet = new DocumentRelationshipSheet(this.workbook, DOCUMENT_RELATIONSHIP_SHEET_NAME);
        this.packageSheet = new PackageSheet(this.workbook, PACKAGE_SHEET_NAME);
        this.extractedLicenseSheet = new ExtractedLicenseSheet(this.workbook, EXTRACTED_LICENSE_SHEET_NAME);
        this.fileSpdxIdSheet = new FileSpdxIdSheet(this.workbook, FILE_SPDX_ID_SHEET_NAME);
        this.fileTypeSheet = new FileTypeSheet(this.workbook, FILE_TYPE_SHEET_NAME);
        this.fileChecksumSheet = new FileChecksumSheet(this.workbook, FILE_CHECKSUM_SHEET_NAME);
        this.fileConcludedSheet = new FileConcludedSheet(this.workbook, FILE_CONCLUDED_SHEET_NAME);
        this.fileLicenseInfoSheet = new FileLicenseInfoSheet(this.workbook, FILE_FOUND_SHEET_NAME);
        this.fileLicenseCommentsSheet = new FileLicenseCommentsSheet(this.workbook, FILE_LICENSE_COMMENT_SHEET_NAME);
        this.fileCopyrightSheet = new FileCopyrightSheet(this.workbook, FILE_COPYRIGHT_SHEET_NAME);
        this.fileCommentSheet = new FileCommentSheet(this.workbook, FILE_COMMENT_SHEET_NAME);
        this.fileNoticeSheet = new FileNoticeSheet(this.workbook, FILE_NOTICE_SHEET_NAME);
        this.fileContributorsSheet = new FileContributorsSheet(this.workbook, FILE_CONTRIBUTOR_SHEET_NAME);
        this.fileAttributionSheet = new FileAttributionSheet(this.workbook, FILE_ATTRIBUTION_SHEET_NAME);
        this.fileAnnotationSheet = new FileAnnotationSheet(this.workbook, FILE_ANNOTATION_SHEET_NAME);
        this.fileRelationshipSheet = new FileRelationshipSheet(this.workbook, FILE_RELATIONSHIP_SHEET);
        this.snippetSheet = new SnippetSheet(this.workbook, SNIPPET_SHEET_NAME);
        this.verificationSheet = new VerificationSheet(this.workbook, VERIFICATION_SHEET_NAME);
        String verify = this.verifyWorkbook();
        if (verify != null && !verify.isEmpty()) {
            logger.error("Invalid workbook: " + verify);
            throw new SpreadsheetException("Invalid workbook: " + verify);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create(File spreadsheetFile) throws IOException, SpreadsheetException {
        if (!spreadsheetFile.createNewFile()) {
            logger.error("Unable to create " + spreadsheetFile.getName());
            throw new SpreadsheetException("Unable to create " + spreadsheetFile.getName());
        }
        try (FileOutputStream excelOut = null;){
            excelOut = new FileOutputStream(spreadsheetFile);
            XSSFWorkbook wb = new XSSFWorkbook();
            DocumentSheet.create((Workbook)wb, DOCUMENT_SHEET_NAME);
            CreatorSheet.create((Workbook)wb, CREATOR_SHEET_NAME);
            ExternalReferencesSheet.create((Workbook)wb, EXTERNAL_REFERENCES_SHEET_NAME);
            DocumentAnnotationSheet.create((Workbook)wb, DOCUMENT_ANNOTATION_SHEET_NAME);
            DocumentRelationshipSheet.create((Workbook)wb, DOCUMENT_RELATIONSHIP_SHEET_NAME);
            PackageSheet.create((Workbook)wb, PACKAGE_SHEET_NAME);
            ExtractedLicenseSheet.create((Workbook)wb, EXTRACTED_LICENSE_SHEET_NAME);
            FileSpdxIdSheet.create((Workbook)wb, FILE_SPDX_ID_SHEET_NAME);
            FileChecksumSheet.create((Workbook)wb, FILE_CHECKSUM_SHEET_NAME);
            FileConcludedSheet.create((Workbook)wb, FILE_CONCLUDED_SHEET_NAME);
            FileLicenseInfoSheet.create((Workbook)wb, FILE_FOUND_SHEET_NAME);
            FileCommentSheet.create((Workbook)wb, FILE_COMMENT_SHEET_NAME);
            FileCopyrightSheet.create((Workbook)wb, FILE_COPYRIGHT_SHEET_NAME);
            FileLicenseCommentsSheet.create((Workbook)wb, FILE_LICENSE_COMMENT_SHEET_NAME);
            FileTypeSheet.create((Workbook)wb, FILE_TYPE_SHEET_NAME);
            FileContributorsSheet.create((Workbook)wb, FILE_CONTRIBUTOR_SHEET_NAME);
            FileAttributionSheet.create((Workbook)wb, FILE_ATTRIBUTION_SHEET_NAME);
            FileNoticeSheet.create((Workbook)wb, FILE_NOTICE_SHEET_NAME);
            FileAnnotationSheet.create((Workbook)wb, FILE_ANNOTATION_SHEET_NAME);
            FileRelationshipSheet.create((Workbook)wb, FILE_RELATIONSHIP_SHEET);
            SnippetSheet.create((Workbook)wb, SNIPPET_SHEET_NAME);
            VerificationSheet.create((Workbook)wb, VERIFICATION_SHEET_NAME);
            wb.write((OutputStream)excelOut);
        }
    }

    public void importCompareResults(SpdxComparer comparer, List<String> docNames) throws SpdxCompareException, InvalidSPDXAnalysisException {
        if (docNames == null) {
            throw new SpdxCompareException("Doc names can not be null");
        }
        if (comparer == null) {
            throw new SpdxCompareException("Comparer names can not be null");
        }
        if (docNames.size() != comparer.getNumSpdxDocs()) {
            throw new SpdxCompareException("Number of document names does not match the number of documents compared");
        }
        ArrayList<List<SpdxFile>> files = new ArrayList<List<SpdxFile>>();
        for (int i = 0; i < comparer.getNumSpdxDocs(); ++i) {
            List docFiles = comparer.collectAllFiles(comparer.getSpdxDoc(i));
            Collections.sort(docFiles, this.fileComparator);
            files.add(docFiles);
        }
        this.documentSheet.importCompareResults(comparer, docNames);
        this.documentSheet.resizeRows();
        this.creatorSheet.importCompareResults(comparer, docNames);
        this.creatorSheet.resizeRows();
        this.externalReferencesSheet.importCompareResults(comparer, docNames);
        this.externalReferencesSheet.resizeRows();
        this.documentAnnotationSheet.importCompareResults(comparer, docNames);
        this.documentAnnotationSheet.resizeRows();
        this.documentRelationshipSheet.importCompareResults(comparer, docNames);
        this.documentRelationshipSheet.resizeRows();
        this.packageSheet.importCompareResults(comparer, docNames);
        this.packageSheet.resizeRows();
        this.fileSpdxIdSheet.importCompareResults(comparer, files, docNames);
        this.fileSpdxIdSheet.resizeRows();
        this.extractedLicenseSheet.importCompareResults(comparer, docNames);
        this.extractedLicenseSheet.resizeRows();
        this.fileChecksumSheet.importCompareResults(comparer, files, docNames);
        this.fileChecksumSheet.resizeRows();
        this.fileConcludedSheet.importCompareResults(comparer, files, docNames);
        this.fileConcludedSheet.resizeRows();
        this.fileLicenseInfoSheet.importCompareResults(comparer, files, docNames);
        this.fileLicenseInfoSheet.resizeRows();
        this.fileCopyrightSheet.importCompareResults(comparer, files, docNames);
        this.fileCopyrightSheet.resizeRows();
        this.fileCommentSheet.importCompareResults(comparer, files, docNames);
        this.fileCommentSheet.resizeRows();
        this.fileLicenseCommentsSheet.importCompareResults(comparer, files, docNames);
        this.fileLicenseCommentsSheet.resizeRows();
        this.fileTypeSheet.importCompareResults(comparer, files, docNames);
        this.fileTypeSheet.resizeRows();
        this.fileContributorsSheet.importCompareResults(comparer, files, docNames);
        this.fileContributorsSheet.resizeRows();
        this.fileAttributionSheet.importCompareResults(comparer, files, docNames);
        this.fileAttributionSheet.resizeRows();
        this.fileNoticeSheet.importCompareResults(comparer, files, docNames);
        this.fileNoticeSheet.resizeRows();
        this.fileAnnotationSheet.importCompareResults(comparer, files, docNames);
        this.fileAnnotationSheet.resizeRows();
        this.fileRelationshipSheet.importCompareResults(comparer, files, docNames);
        this.fileRelationshipSheet.resizeRows();
        this.snippetSheet.importCompareResults(comparer, docNames);
        this.snippetSheet.resizeRows();
    }

    public void clear() {
        this.documentSheet.clear();
        this.creatorSheet.clear();
        this.packageSheet.clear();
        this.extractedLicenseSheet.clear();
        this.fileChecksumSheet.clear();
        this.fileConcludedSheet.clear();
        this.fileLicenseInfoSheet.clear();
        this.fileLicenseCommentsSheet.clear();
        this.verificationSheet.clear();
        this.fileCommentSheet.clear();
        this.fileContributorsSheet.clear();
        this.fileAttributionSheet.clear();
        this.fileNoticeSheet.clear();
        this.snippetSheet.clear();
    }

    public String verifyWorkbook() {
        StringBuilder sb = new StringBuilder();
        String sheetVerify = this.documentSheet.verify();
        if (sheetVerify != null && !sheetVerify.isEmpty()) {
            sb.append(sheetVerify);
        }
        if ((sheetVerify = this.creatorSheet.verify()) != null && !sheetVerify.isEmpty()) {
            sb.append("; ");
            sb.append(sheetVerify);
        }
        if ((sheetVerify = this.packageSheet.verify()) != null && !sheetVerify.isEmpty()) {
            sb.append("; ");
            sb.append(sheetVerify);
        }
        if ((sheetVerify = this.extractedLicenseSheet.verify()) != null && !sheetVerify.isEmpty()) {
            sb.append("; ");
            sb.append(sheetVerify);
        }
        if ((sheetVerify = this.fileChecksumSheet.verify()) != null && !sheetVerify.isEmpty()) {
            sb.append("; ");
            sb.append(sheetVerify);
        }
        if ((sheetVerify = this.fileConcludedSheet.verify()) != null && !sheetVerify.isEmpty()) {
            sb.append("; ");
            sb.append(sheetVerify);
        }
        if ((sheetVerify = this.fileLicenseInfoSheet.verify()) != null && !sheetVerify.isEmpty()) {
            sb.append("; ");
            sb.append(sheetVerify);
        }
        if ((sheetVerify = this.fileCommentSheet.verify()) != null && !sheetVerify.isEmpty()) {
            sb.append("; ");
            sb.append(sheetVerify);
        }
        if ((sheetVerify = this.fileLicenseCommentsSheet.verify()) != null && !sheetVerify.isEmpty()) {
            sb.append("; ");
            sb.append(sheetVerify);
        }
        if ((sheetVerify = this.fileContributorsSheet.verify()) != null && !sheetVerify.isEmpty()) {
            sb.append("; ");
            sb.append(sheetVerify);
        }
        if ((sheetVerify = this.fileAttributionSheet.verify()) != null && !sheetVerify.isEmpty()) {
            sb.append("; ");
            sb.append(sheetVerify);
        }
        if ((sheetVerify = this.fileNoticeSheet.verify()) != null && !sheetVerify.isEmpty()) {
            sb.append("; ");
            sb.append(sheetVerify);
        }
        if ((sheetVerify = this.verificationSheet.verify()) != null && !sheetVerify.isEmpty()) {
            sb.append("; ");
            sb.append(sheetVerify);
        }
        if ((sheetVerify = this.snippetSheet.verify()) != null && !sheetVerify.isEmpty()) {
            sb.append("; ");
            sb.append(sheetVerify);
        }
        if (sb.length() > 0) {
            return sb.toString();
        }
        return null;
    }

    public void importVerificationErrors(List<List<String>> verificationErrors, List<String> docNames) throws SpreadsheetException {
        this.verificationSheet.importVerificationErrors(verificationErrors, docNames);
        this.verificationSheet.resizeRows();
    }

    public void close() throws SpreadsheetException {
        try {
            this.writeToFile(this.saveFile);
        }
        catch (IOException ex) {
            logger.error("Error writing excel sheet to file: " + ex.getMessage());
            throw new SpreadsheetException("Error writing excel workbook to file, see log for details.");
        }
    }

    public void writeToFile(File file) throws IOException {
        if (this.readonly) {
            return;
        }
        try (FileOutputStream out = null;){
            out = new FileOutputStream(file);
            this.workbook.write((OutputStream)out);
        }
    }

    public DocumentSheet getDocumentSheet() {
        return this.documentSheet;
    }

    protected static final class SpdxFileComparator
    implements Comparator<SpdxFile> {
        private NormalizedFileNameComparator normalizedFileNameComparator = new NormalizedFileNameComparator();

        protected SpdxFileComparator() {
        }

        @Override
        public int compare(SpdxFile arg0, SpdxFile arg1) {
            try {
                return this.normalizedFileNameComparator.compare(arg0.getName(), arg1.getName());
            }
            catch (InvalidSPDXAnalysisException e) {
                logger.error("Error getting SPDX file names", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }
}

