/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.tools;

import java.io.IOException;
import java.util.Comparator;
import java.util.Properties;
import org.spdx.library.ListedLicenses;
import org.spdx.library.SpdxModelFactory;

public class SpdxVersion {
    public static String getCurrentToolVersion() {
        Properties properties = new Properties();
        try {
            properties.load(SpdxVersion.class.getClassLoader().getResourceAsStream("project.properties"));
            return properties.getProperty("version");
        }
        catch (IOException e) {
            return "Unknown tool version";
        }
    }

    public static String getLibraryVersion() {
        return "2.0.0";
    }

    public static String getLatestSpecVersion() {
        return SpdxModelFactory.getLatestSpecVersion();
    }

    public static String getLicenseListVersion() {
        return ListedLicenses.getListedLicenses().getLicenseListVersion();
    }

    static class SpdxVersionComparer
    implements Comparator<String> {
        SpdxVersionComparer() {
        }

        private String normalizeVersion(String version) {
            if (version.startsWith("SPDX-")) {
                return version.substring("SPDX-".length());
            }
            return version;
        }

        @Override
        public int compare(String versionA, String versionB) {
            return this.normalizeVersion(versionA).compareTo(this.normalizeVersion(versionB));
        }
    }
}

