/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.tools.compare;

import org.apache.poi.ss.usermodel.Workbook;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.library.model.v2.SpdxFile;
import org.spdx.tools.compare.AbstractFileCompareSheet;
import org.spdx.tools.compare.CompareHelper;
import org.spdx.utility.compare.SpdxCompareException;
import org.spdx.utility.compare.SpdxComparer;

public class FileAnnotationSheet
extends AbstractFileCompareSheet {
    static final int ANNOTATION_COL_WIDTH = 80;

    public FileAnnotationSheet(Workbook workbook, String sheetName) {
        super(workbook, sheetName);
    }

    static void create(Workbook wb, String sheetName) {
        AbstractFileCompareSheet.create(wb, sheetName, 80);
    }

    @Override
    boolean valuesMatch(SpdxComparer comparer, SpdxFile fileA, int docIndexA, SpdxFile fileB, int docIndexB) throws SpdxCompareException, InvalidSPDXAnalysisException {
        return CompareHelper.equivalent(fileA.getAnnotations(), fileB.getAnnotations());
    }

    @Override
    String getFileValue(SpdxFile spdxFile) throws InvalidSPDXAnalysisException {
        return CompareHelper.annotationsToString(spdxFile.getAnnotations());
    }
}

