/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.tools;

import java.io.File;
import java.io.PrintWriter;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.library.model.v2.SpdxDocument;
import org.spdx.storage.ISerializableModelStore;
import org.spdx.tag.CommonCode;
import org.spdx.tools.SpdxToolsHelper;
import org.spdx.tools.SpdxVerificationException;

public class SpdxViewer {
    static final int MIN_ARGS = 1;
    static final int MAX_ARGS = 2;
    static final int ERROR_STATUS = 1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        if (args.length < 1) {
            System.err.println("Usage:\n SPDXViewer file [RDFXML|JSON|XLS|XLSX|YAML|TAG] \nwhere file is the file path to a valid SPDX file\nand [RDFXML|JSON|XLS|XLSX|YAML|TAG|JSONLD] is an optional file type\nif not present, file type of the to file will be used");
            return;
        }
        if (args.length > 2) {
            System.out.printf("Warning: Extra arguments will be ignored", new Object[0]);
        }
        SpdxToolsHelper.initialize();
        SpdxDocument doc = null;
        ISerializableModelStore store = null;
        PrintWriter writer = null;
        try {
            File file = new File(args[0]);
            if (!file.exists()) {
                throw new SpdxVerificationException("File " + args[0] + " not found.");
            }
            if (!file.isFile()) {
                throw new SpdxVerificationException(args[0] + " is not a file.");
            }
            SpdxToolsHelper.SerFileType fileType = null;
            if (args.length > 1) {
                try {
                    fileType = SpdxToolsHelper.strToFileType(args[1]);
                }
                catch (Exception ex) {
                    System.err.println("Invalid file type: " + args[1]);
                    System.exit(1);
                }
            } else {
                fileType = SpdxToolsHelper.fileToFileType(file);
            }
            try {
                store = SpdxToolsHelper.fileTypeToStore(fileType);
            }
            catch (InvalidSPDXAnalysisException e) {
                throw new SpdxVerificationException("Error converting fileType to store", e);
            }
            try {
                doc = SpdxToolsHelper.readDocumentFromFileCompatV2(store, file);
            }
            catch (Exception ex) {
                System.out.print("Error creating SPDX Document: " + ex.getMessage());
                if (Objects.nonNull(writer)) {
                    writer.close();
                }
                if (Objects.nonNull(store)) {
                    try {
                        store.close();
                    }
                    catch (Exception e) {
                        System.out.println("Warning - unable to close SPDX file: " + e.getMessage());
                    }
                }
                return;
            }
            writer = new PrintWriter(System.out);
            List verify = doc.verify();
            if (verify.size() > 0) {
                System.out.println("This SPDX Document is not valid due to:");
                for (int i = 0; i < verify.size(); ++i) {
                    System.out.print("\t" + (String)verify.get(i) + "\n");
                }
            }
            Properties constants = CommonCode.getTextFromProperties((String)"org/spdx/tag/SpdxViewerConstants.properties");
            CommonCode.printDoc((SpdxDocument)doc, (PrintWriter)writer, (Properties)constants);
        }
        catch (InvalidSPDXAnalysisException e) {
            System.out.print("Error pretty printing SPDX Document: " + e.getMessage());
            return;
        }
        catch (Exception e) {
            System.out.print("Unexpected error displaying SPDX Document: " + e.getMessage());
        }
        finally {
            if (Objects.nonNull(writer)) {
                writer.close();
            }
            if (Objects.nonNull(store)) {
                try {
                    store.close();
                }
                catch (Exception e) {
                    System.out.println("Warning - unable to close SPDX file: " + e.getMessage());
                }
            }
        }
    }
}

