/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.tools.compare;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.library.model.v2.Annotation;
import org.spdx.tools.compare.AbstractSheet;
import org.spdx.utility.compare.SpdxCompareException;
import org.spdx.utility.compare.SpdxComparer;

public class DocumentAnnotationSheet
extends AbstractSheet {
    AnnotationComparator annotationComparator = new AnnotationComparator();
    static final int ANNOTATOR_COL = 0;
    static final int ANNOTATOR_COL_WIDTH = 40;
    static final String ANNOTATOR_COL_TEXT_TITLE = "Annotator";
    static final int TYPE_COL = 1;
    static final int TYPE_COL_WIDTH = 15;
    static final String TYPE_COL_TEXT_TITLE = "Type";
    static final int COMMENT_COL = 2;
    static final int COMMENT_COL_WIDTH = 70;
    static final String COMMENT_COL_TEXT_TITLE = "Comment";
    static final int FIRST_DATE_COL = 3;
    static final int DATE_COL_WIDTH = 25;

    public DocumentAnnotationSheet(Workbook workbook, String sheetName) {
        super(workbook, sheetName);
    }

    public static void create(Workbook wb, String sheetName) {
        int sheetNum = wb.getSheetIndex(sheetName);
        if (sheetNum >= 0) {
            wb.removeSheetAt(sheetNum);
        }
        Sheet sheet = wb.createSheet(sheetName);
        CellStyle headerStyle = AbstractSheet.createHeaderStyle(wb);
        CellStyle defaultStyle = AbstractSheet.createLeftWrapStyle(wb);
        Row row = sheet.createRow(0);
        sheet.setColumnWidth(0, 10240);
        sheet.setDefaultColumnStyle(0, defaultStyle);
        Cell annotatorHeaderCell = row.createCell(0);
        annotatorHeaderCell.setCellStyle(headerStyle);
        annotatorHeaderCell.setCellValue(ANNOTATOR_COL_TEXT_TITLE);
        sheet.setColumnWidth(1, 3840);
        sheet.setDefaultColumnStyle(1, defaultStyle);
        Cell typeHeaderCell = row.createCell(1);
        typeHeaderCell.setCellStyle(headerStyle);
        typeHeaderCell.setCellValue(TYPE_COL_TEXT_TITLE);
        sheet.setColumnWidth(2, 17920);
        sheet.setDefaultColumnStyle(2, defaultStyle);
        Cell commentHeaderCell = row.createCell(2);
        commentHeaderCell.setCellStyle(headerStyle);
        commentHeaderCell.setCellValue(COMMENT_COL_TEXT_TITLE);
        for (int i = 3; i < 25; ++i) {
            sheet.setColumnWidth(i, 6400);
            sheet.setDefaultColumnStyle(i, defaultStyle);
            Cell cell = row.createCell(i);
            cell.setCellStyle(headerStyle);
        }
    }

    public void importCompareResults(SpdxComparer comparer, List<String> docNames) throws SpdxCompareException, InvalidSPDXAnalysisException {
        if (comparer.getNumSpdxDocs() != docNames.size()) {
            throw new SpdxCompareException("Number of document names does not match the number of SPDX documents");
        }
        this.clear();
        Row header = this.sheet.getRow(0);
        int[] annotationIndexes = new int[comparer.getNumSpdxDocs()];
        Annotation[][] annotations = new Annotation[comparer.getNumSpdxDocs()][];
        for (int i = 0; i < annotations.length; ++i) {
            Cell headerCell = header.getCell(3 + i);
            headerCell.setCellValue(docNames.get(i));
            Annotation[] docAnnotations = comparer.getSpdxDoc(i).getAnnotations().toArray(new Annotation[comparer.getSpdxDoc(i).getAnnotations().size()]);
            Arrays.sort(docAnnotations, this.annotationComparator);
            annotations[i] = docAnnotations;
            annotationIndexes[i] = 0;
        }
        while (!this.allAnnotationsExhausted(annotations, annotationIndexes)) {
            Row currentRow = this.addRow();
            Annotation nextAnnotation = this.getNextAnnotation(annotations, annotationIndexes);
            if (!Objects.nonNull(nextAnnotation)) continue;
            Cell annotatorCell = currentRow.createCell(0);
            annotatorCell.setCellValue(nextAnnotation.getAnnotator());
            Cell typeCell = currentRow.createCell(1);
            typeCell.setCellValue(nextAnnotation.getAnnotationType().toString());
            Cell commentCell = currentRow.createCell(2);
            commentCell.setCellValue(nextAnnotation.getComment());
            for (int i = 0; i < annotations.length; ++i) {
                Annotation compareAnnotation;
                if (annotations[i].length <= annotationIndexes[i] || this.annotationComparator.compare(nextAnnotation, compareAnnotation = annotations[i][annotationIndexes[i]]) != 0) continue;
                Cell dateCell = currentRow.createCell(3 + i);
                dateCell.setCellValue(annotations[i][annotationIndexes[i]].getAnnotationDate());
                int n = i;
                annotationIndexes[n] = annotationIndexes[n] + 1;
            }
        }
    }

    private Annotation getNextAnnotation(Annotation[][] annotations, int[] annotationIndexes) {
        Annotation retval = null;
        for (int i = 0; i < annotations.length; ++i) {
            if (annotations[i].length <= annotationIndexes[i]) continue;
            Annotation candidate = annotations[i][annotationIndexes[i]];
            if (retval != null && this.annotationComparator.compare(retval, candidate) <= 0) continue;
            retval = candidate;
        }
        return retval;
    }

    private boolean allAnnotationsExhausted(Annotation[][] annotations, int[] annotationIndexes) {
        for (int i = 0; i < annotations.length; ++i) {
            if (annotationIndexes[i] >= annotations[i].length) continue;
            return false;
        }
        return true;
    }

    @Override
    public String verify() {
        return null;
    }

    private static class AnnotationComparator
    implements Comparator<Annotation>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private AnnotationComparator() {
        }

        @Override
        public int compare(Annotation o1, Annotation o2) {
            try {
                if (o1 != null) {
                    if (o2 != null) {
                        Annotation a1 = o1;
                        Annotation a2 = o2;
                        int retval = a1.getAnnotator().compareTo(a2.getAnnotator());
                        if (retval != 0) {
                            return retval;
                        }
                        retval = a1.getAnnotationType().toString().compareTo(a2.getAnnotationType().toString());
                        if (retval != 0) {
                            return retval;
                        }
                        return a1.getComment().compareTo(a2.getComment());
                    }
                    return 1;
                }
                return -1;
            }
            catch (InvalidSPDXAnalysisException ex) {
                AbstractSheet.logger.error("Error comparing annotations", (Throwable)ex);
                throw new RuntimeException(ex);
            }
        }
    }
}

