/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.tools;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spdx.core.CoreModelObject;
import org.spdx.core.IModelCopyManager;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.library.ModelCopyManager;
import org.spdx.library.model.v2.SpdxDocument;
import org.spdx.spreadsheetstore.SpreadsheetException;
import org.spdx.storage.IModelStore;
import org.spdx.storage.simple.InMemSpdxStore;
import org.spdx.tools.InvalidFileNameException;
import org.spdx.tools.OnlineToolException;
import org.spdx.tools.SpdxToolsHelper;
import org.spdx.tools.compare.MultiDocumentSpreadsheet;
import org.spdx.utility.compare.SpdxCompareException;
import org.spdx.utility.compare.SpdxComparer;

public class CompareSpdxDocs {
    static final int MIN_ARGS = 2;
    static final int MAX_ARGS = 26;
    static final int ERROR_STATUS = 1;
    static final Logger logger = LoggerFactory.getLogger(CompareSpdxDocs.class);

    public static void main(String[] args) {
        if (args.length < 2) {
            System.out.println("Insufficient arguments");
            CompareSpdxDocs.usage();
            System.exit(1);
        }
        if (args.length > 26) {
            System.out.println("Too many SPDX documents specified.  Must be less than " + String.valueOf(25) + " document filenames");
            CompareSpdxDocs.usage();
            System.exit(1);
        }
        SpdxToolsHelper.initialize();
        try {
            CompareSpdxDocs.onlineFunction(args);
        }
        catch (OnlineToolException e) {
            System.out.println(e.getMessage());
            System.exit(1);
        }
    }

    public static void onlineFunction(String[] args) throws OnlineToolException {
        File outputFile = new File(args[0]);
        if (outputFile.exists()) {
            throw new OnlineToolException("Output file " + args[0] + " already exists. Change the name of the result file.");
        }
        ArrayList<SpdxDocument> compareDocs = new ArrayList<SpdxDocument>();
        ArrayList<List<String>> verificationErrors = new ArrayList<List<String>>();
        ArrayList<String> docNames = new ArrayList<String>();
        for (int i = 1; i < args.length; ++i) {
            try {
                CompareSpdxDocs.addDocToComparer(compareDocs, args[i], docNames, verificationErrors);
                continue;
            }
            catch (IOException | InvalidSPDXAnalysisException | InvalidFileNameException e) {
                throw new OnlineToolException("Error opening SPDX document " + args[i] + ": " + e.getMessage());
            }
        }
        List<String> normalizedDocNames = CompareSpdxDocs.normalizeDocNames(docNames);
        MultiDocumentSpreadsheet outSheet = null;
        try {
            outSheet = new MultiDocumentSpreadsheet(outputFile, true, false);
            outSheet.importVerificationErrors(verificationErrors, normalizedDocNames);
            SpdxComparer comparer = new SpdxComparer();
            comparer.compare(compareDocs);
            outSheet.importCompareResults(comparer, normalizedDocNames);
        }
        catch (SpreadsheetException e) {
            throw new OnlineToolException("Unable to create output spreadsheet: " + e.getMessage());
        }
        catch (InvalidSPDXAnalysisException e) {
            throw new OnlineToolException("Invalid SPDX analysis: " + e.getMessage());
        }
        catch (SpdxCompareException e) {
            throw new OnlineToolException("Error comparing SPDX documents: " + e.getMessage());
        }
        finally {
            if (outSheet != null) {
                try {
                    outSheet.close();
                }
                catch (SpreadsheetException e) {
                    logger.warn("Warning - error closing spreadsheet: " + e.getMessage());
                }
            }
        }
    }

    private static void addDocToComparer(List<SpdxDocument> compareDocs, String filePath, List<String> docNames, List<List<String>> verificationErrors) throws InvalidSPDXAnalysisException, IOException, InvalidFileNameException {
        File spdxDocOrDir = new File(filePath);
        if (!spdxDocOrDir.exists()) {
            throw new FileNotFoundException("File " + filePath + " not found");
        }
        if (spdxDocOrDir.isFile()) {
            SpdxDocument doc = SpdxToolsHelper.deserializeDocumentCompatV2(spdxDocOrDir);
            List warnings = doc.verify();
            boolean dupDocUri = false;
            for (SpdxDocument otherDocs : compareDocs) {
                if (!otherDocs.getDocumentUri().equals(doc.getDocumentUri())) continue;
                dupDocUri = true;
                break;
            }
            if (dupDocUri) {
                String newUri = doc.getDocumentUri() + String.valueOf(UUID.randomUUID());
                warnings.add("Duplicate Document URI: " + doc.getDocumentUri() + " changed to " + newUri);
                InMemSpdxStore newStore = new InMemSpdxStore();
                ModelCopyManager copyManager = new ModelCopyManager();
                SpdxDocument newDoc = new SpdxDocument((IModelStore)newStore, newUri, (IModelCopyManager)copyManager, false);
                newDoc.copyFrom((CoreModelObject)doc);
                doc = newDoc;
            }
            compareDocs.add(doc);
            if (!warnings.isEmpty()) {
                System.out.println("Verification errors were found in " + filePath.trim() + ".  See verification errors sheet for details.");
            }
            verificationErrors.add(warnings);
            docNames.add(filePath);
        } else if (spdxDocOrDir.isDirectory()) {
            for (File file : spdxDocOrDir.listFiles()) {
                try {
                    CompareSpdxDocs.addDocToComparer(compareDocs, file.getPath(), docNames, verificationErrors);
                }
                catch (IOException | InvalidSPDXAnalysisException | InvalidFileNameException e) {
                    System.out.println("Error deserializing " + String.valueOf(file) + ".  Skipping.");
                }
            }
        }
    }

    private static List<String> normalizeDocNames(List<String> uriFilePaths) {
        int i;
        ArrayList<String> docNames = new ArrayList<String>();
        if (uriFilePaths.size() < 1) {
            return docNames;
        }
        int commonPrefixIndex = uriFilePaths.get(0).length();
        for (i = 1; i < uriFilePaths.size(); ++i) {
            if (uriFilePaths.get(i).length() >= commonPrefixIndex) continue;
            commonPrefixIndex = uriFilePaths.get(i).length();
        }
        block1: for (i = 1; i < uriFilePaths.size(); ++i) {
            for (int j = 0; j < commonPrefixIndex; ++j) {
                if (uriFilePaths.get(i - 1).charAt(j) == uriFilePaths.get(i).charAt(j)) continue;
                commonPrefixIndex = j;
                continue block1;
            }
        }
        for (i = commonPrefixIndex; i >= 0; --i) {
            if (uriFilePaths.get(0).charAt(i) != '/' && uriFilePaths.get(0).charAt(i) != '\\') continue;
            commonPrefixIndex = i + 1;
            break;
        }
        for (String uriFilePath : uriFilePaths) {
            docNames.add(uriFilePath.substring(commonPrefixIndex).replace("\\", "/"));
        }
        return docNames;
    }

    private static void usage() {
        System.out.println("Usage: CompareMultipleSpdxDoc output.xls doc1 doc2 ... docN");
        System.out.println("where output.xls is a file name for the output spreadsheet file");
        System.out.println("and doc1 through docN are file names of valid SPDX documents ");
        System.out.println("in any of the supported formats format");
    }
}

