/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.tools;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.ontology.OntModelSpec;
import org.apache.jena.rdf.model.ModelFactory;
import org.spdx.tools.schema.OwlToJsonContext;

public class RdfSchemaToJsonContext {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        if (args.length != 2) {
            System.err.println("Invalid number of arguments");
            RdfSchemaToJsonContext.usage();
            return;
        }
        File fromFile = new File(args[0]);
        if (!fromFile.exists()) {
            System.err.println("Input file " + args[0] + " does not exist.");
            RdfSchemaToJsonContext.usage();
            return;
        }
        File toFile = new File(args[1]);
        if (toFile.exists()) {
            System.err.println("Output file " + args[1] + " already exists.");
            RdfSchemaToJsonContext.usage();
            return;
        }
        FileInputStream is = null;
        OwlToJsonContext owlToJsonContext = null;
        try {
            is = new FileInputStream(fromFile);
            OntModel model = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
            model.read((InputStream)is, "RDF/XML");
            owlToJsonContext = new OwlToJsonContext(model);
        }
        catch (FileNotFoundException e) {
            System.err.println("File not found for " + fromFile.getName());
            return;
        }
        finally {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException e) {
                    System.err.println("Error closing input file stream: " + e.getMessage());
                }
            }
        }
        if (Objects.isNull(owlToJsonContext)) {
            System.err.println("Unable to load ontology from file " + fromFile.getName());
            return;
        }
        ObjectNode context = owlToJsonContext.convertToContext();
        JsonGenerator jsonGenerator = null;
        try {
            jsonGenerator = OwlToJsonContext.JSON_MAPPER.getFactory().createGenerator((OutputStream)new FileOutputStream(toFile));
            OwlToJsonContext.JSON_MAPPER.writeTree(jsonGenerator.useDefaultPrettyPrinter(), (JsonNode)context);
        }
        catch (FileNotFoundException e) {
            System.err.println("File not found for " + fromFile.getName());
            return;
        }
        catch (JsonProcessingException e) {
            System.err.println("JSON error " + e.getMessage());
            return;
        }
        catch (IOException e) {
            System.err.println("I/O error: " + e.getMessage());
            return;
        }
        finally {
            if (Objects.nonNull(jsonGenerator)) {
                try {
                    jsonGenerator.close();
                }
                catch (IOException e) {
                    System.err.println("Error closing output file stream: " + e.getMessage());
                }
            }
        }
    }

    public static void usage() {
        System.out.println("Usage:");
        System.out.println("RdfSchemaToJsonContext rdfSchemaFile jsonContextFile");
        System.out.println("\trdfSchemaFile RDF schema file in RDF/XML format");
        System.out.println("\trdfSchemaFile output JSON context file");
    }
}

