/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.tools;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.networknt.schema.Error;
import com.networknt.schema.Schema;
import com.networknt.schema.SchemaRegistry;
import com.networknt.schema.SpecificationVersion;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.spdx.core.CoreModelObject;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.library.model.v2.Version;
import org.spdx.storage.ISerializableModelStore;
import org.spdx.tagvaluestore.TagValueStore;
import org.spdx.tools.InvalidFileNameException;
import org.spdx.tools.SpdxToolsHelper;
import org.spdx.tools.SpdxVerificationException;

public class Verify {
    static final int MIN_ARGS = 1;
    static final int MAX_ARGS = 2;
    static final int ERROR_STATUS = 1;
    public static final String JSON_SCHEMA_RESOURCE_V2_3 = "resources/spdx-schema-v2.3.json";
    public static final String JSON_SCHEMA_RESOURCE_V2_2 = "resources/spdx-schema-v2.2.json";
    public static final String JSON_SCHEMA_RESOURCE_V3 = "resources/spdx-schema-v3.0.1.json";
    static final ObjectMapper JSON_MAPPER = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT);

    public static void main(String[] args) {
        if (args.length < 1) {
            System.err.println("Usage:\n Verify file\nwhere file is the file path to an SPDX file");
            System.exit(1);
        }
        if (args.length > 2) {
            System.out.println("Warning: Extra arguments will be ignored");
        }
        SpdxToolsHelper.initialize();
        List<String> verify = null;
        try {
            SpdxToolsHelper.SerFileType fileType = null;
            if (args.length > 1) {
                try {
                    fileType = SpdxToolsHelper.strToFileType(args[1]);
                }
                catch (Exception ex) {
                    System.err.println("Invalid file type: " + args[1]);
                    System.exit(1);
                }
            } else {
                fileType = SpdxToolsHelper.fileToFileType(new File(args[0]));
            }
            verify = Verify.verify(args[0], fileType);
        }
        catch (SpdxVerificationException e) {
            System.out.println(e.getMessage());
            System.exit(1);
        }
        catch (InvalidFileNameException e) {
            System.err.println("Invalid file name: " + args[0]);
            System.exit(1);
        }
        ArrayList<String> warnings = new ArrayList<String>();
        ArrayList<String> errors = new ArrayList<String>();
        for (String verifyMsg : verify) {
            if (verifyMsg.contains(" is deprecated.")) {
                warnings.add(verifyMsg);
                continue;
            }
            errors.add(verifyMsg);
        }
        if (!errors.isEmpty()) {
            System.out.println("This SPDX Document is not valid due to:");
            for (String errorMsg : errors) {
                System.out.print("\t" + errorMsg + "\n");
            }
        }
        if (!warnings.isEmpty()) {
            System.out.println("Warning: Deprecated license identifiers were found that should no longer be used.\nReferences to the following deprecated license ID's should be updated:");
            for (String warningMsg : warnings) {
                System.out.print("\t" + warningMsg + "\n");
            }
        }
        if (errors.isEmpty()) {
            System.out.println("This SPDX Document is valid.");
        } else {
            System.exit(1);
        }
    }

    public static List<String> verify(String filePath, SpdxToolsHelper.SerFileType fileType) throws SpdxVerificationException {
        List verify;
        Objects.requireNonNull(filePath);
        Objects.requireNonNull(fileType);
        File file = new File(filePath);
        if (!file.exists()) {
            throw new SpdxVerificationException("File " + filePath + " not found.");
        }
        if (!file.isFile()) {
            throw new SpdxVerificationException(filePath + " is not a file.");
        }
        ISerializableModelStore store = null;
        try {
            store = SpdxToolsHelper.fileTypeToStore(fileType);
        }
        catch (InvalidSPDXAnalysisException e) {
            throw new SpdxVerificationException("Error converting fileType to store", e);
        }
        CoreModelObject doc = null;
        try {
            doc = SpdxToolsHelper.readDocumentFromFile(store, file);
        }
        catch (FileNotFoundException e) {
            throw new SpdxVerificationException("File " + filePath + " not found.", e);
        }
        catch (JsonParseException e) {
            throw new SpdxVerificationException("Invalid JSON file: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new SpdxVerificationException("IO Error reading SPDX file", e);
        }
        catch (InvalidSPDXAnalysisException e) {
            throw new SpdxVerificationException("Analysis exception processing SPDX file: " + e.getMessage(), e);
        }
        ArrayList<String> retval = new ArrayList<String>();
        if (store instanceof TagValueStore) {
            retval.addAll(((TagValueStore)store).getWarnings());
        }
        if (SpdxToolsHelper.SerFileType.JSON.equals((Object)fileType) || SpdxToolsHelper.SerFileType.JSONLD.equals((Object)fileType)) {
            try {
                JsonNode root;
                Schema schema;
                String jsonSchemaResource = SpdxToolsHelper.SerFileType.JSON.equals((Object)fileType) ? (Version.versionLessThan((String)"SPDX-2.3", (String)doc.getSpecVersion()) ? JSON_SCHEMA_RESOURCE_V2_2 : JSON_SCHEMA_RESOURCE_V2_3) : JSON_SCHEMA_RESOURCE_V3;
                SchemaRegistry schemaRegistry = SchemaRegistry.withDefaultDialect((SpecificationVersion)SpecificationVersion.DRAFT_2020_12);
                try (InputStream is = Verify.class.getResourceAsStream("/" + jsonSchemaResource);){
                    schema = schemaRegistry.getSchema(is);
                }
                try (FileInputStream is = new FileInputStream(file);){
                    root = JSON_MAPPER.readTree((InputStream)is);
                }
                List messages = schema.validate(root);
                for (Error msg : messages) {
                    retval.add(msg.toString());
                }
            }
            catch (IOException e) {
                retval.add("Unable to validate JSON file against schema due to I/O Error");
            }
            catch (InvalidSPDXAnalysisException e) {
                retval.add("Unable to validate JSON file against schema due to error in SPDX file");
            }
        }
        if (SpdxToolsHelper.SerFileType.JSONLD.equals((Object)fileType)) {
            // empty if block
        }
        try {
            verify = doc.verify(doc.getSpecVersion());
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Error processing verify for the specific version");
            verify = doc.verify();
        }
        if (!verify.isEmpty()) {
            for (String verifyMsg : verify) {
                if (retval.contains(verifyMsg)) continue;
                if (verifyMsg.contains(" is deprecated.")) {
                    verifyMsg = verifyMsg.replaceAll("error:", "warning:");
                }
                retval.add(verifyMsg);
            }
        }
        return retval;
    }

    public static List<String> verifyTagFile(String filePath) throws SpdxVerificationException {
        return Verify.verify(filePath, SpdxToolsHelper.SerFileType.TAG);
    }

    public static List<String> verifyRDFFile(String filePath) throws SpdxVerificationException {
        return Verify.verify(filePath, SpdxToolsHelper.SerFileType.RDFXML);
    }

    public void usage() {
        System.out.println("Verify filepath [RDFXML|JSON|XLS|XLSX|YAML|TAG|JSONLD]");
        System.out.println("    where filepath is a path to the SPDX file and [RDFXML|JSON|XLS|XLSX|YAML|TAG] is an optional file type - if not present, file type of the to file will be used");
    }
}

