/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.tools.compare;

import java.util.Objects;
import org.apache.poi.ss.usermodel.Workbook;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.library.model.v2.SpdxFile;
import org.spdx.tools.compare.AbstractFileCompareSheet;
import org.spdx.utility.compare.SpdxCompareException;
import org.spdx.utility.compare.SpdxComparer;

public class FileChecksumSheet
extends AbstractFileCompareSheet {
    private static final int CHECKSUM_COL_WIDTH = 41;

    public FileChecksumSheet(Workbook workbook, String sheetName) {
        super(workbook, sheetName);
    }

    static void create(Workbook wb, String sheetName) {
        AbstractFileCompareSheet.create(wb, sheetName, 41);
    }

    @Override
    String getFileValue(SpdxFile spdxFile) throws InvalidSPDXAnalysisException {
        return spdxFile.getSha1();
    }

    @Override
    boolean valuesMatch(SpdxComparer comparer, SpdxFile fileA, int docIndexA, SpdxFile fileB, int docIndexB) throws SpdxCompareException, InvalidSPDXAnalysisException {
        return Objects.equals(fileA.getSha1(), fileB.getSha1());
    }
}

