/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.tools.compare;

import java.util.Collection;
import java.util.Iterator;
import org.apache.poi.ss.usermodel.Workbook;
import org.spdx.library.model.v2.SpdxFile;
import org.spdx.tools.compare.AbstractFileCompareSheet;
import org.spdx.utility.compare.SpdxCompareException;
import org.spdx.utility.compare.SpdxComparer;

public class FileContributorsSheet
extends AbstractFileCompareSheet {
    private static final int FILE_CONTRIBUTOR_COL_WIDTH = 50;

    public FileContributorsSheet(Workbook workbook, String sheetName) {
        super(workbook, sheetName);
    }

    static void create(Workbook wb, String sheetName) {
        AbstractFileCompareSheet.create(wb, sheetName, 50);
    }

    @Override
    boolean valuesMatch(SpdxComparer comparer, SpdxFile fileA, int docIndexA, SpdxFile fileB, int docIndexB) throws SpdxCompareException {
        return SpdxComparer.stringCollectionsEqual((Collection)fileA.getFileContributors(), (Collection)fileB.getFileContributors());
    }

    @Override
    String getFileValue(SpdxFile spdxFile) {
        StringBuilder sb = new StringBuilder();
        Collection contributors = spdxFile.getFileContributors();
        if (contributors != null && contributors.size() > 0) {
            Iterator iter = contributors.iterator();
            sb.append((String)iter.next());
            while (iter.hasNext()) {
                sb.append(", ");
                sb.append((String)iter.next());
            }
        }
        return sb.toString();
    }
}

