/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.tools.compare;

import java.util.Arrays;
import org.apache.poi.ss.usermodel.Workbook;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.library.model.v2.SpdxFile;
import org.spdx.library.model.v2.enumerations.FileType;
import org.spdx.tools.compare.AbstractFileCompareSheet;
import org.spdx.utility.compare.SpdxCompareException;
import org.spdx.utility.compare.SpdxComparer;

public class FileTypeSheet
extends AbstractFileCompareSheet {
    private static final int FILE_TYPE_COL_WIDTH = 20;

    public FileTypeSheet(Workbook workbook, String sheetName) {
        super(workbook, sheetName);
    }

    static void create(Workbook wb, String sheetName) {
        AbstractFileCompareSheet.create(wb, sheetName, 20);
    }

    @Override
    String getFileValue(SpdxFile spdxFile) throws InvalidSPDXAnalysisException {
        if (spdxFile.getFileTypes() == null || spdxFile.getFileTypes().size() == 0) {
            return "";
        }
        FileType[] fileTypes = spdxFile.getFileTypes().toArray(new FileType[spdxFile.getFileTypes().size()]);
        Object[] sFileTypes = new String[fileTypes.length];
        for (int i = 0; i < fileTypes.length; ++i) {
            sFileTypes[i] = fileTypes[i].toString();
        }
        Arrays.sort(sFileTypes);
        StringBuilder sb = new StringBuilder((String)sFileTypes[0]);
        for (int i = 1; i < sFileTypes.length; ++i) {
            sb.append(", ");
            sb.append((String)sFileTypes[i]);
        }
        return sb.toString();
    }

    @Override
    boolean valuesMatch(SpdxComparer comparer, SpdxFile fileA, int docIndexA, SpdxFile fileB, int docIndexB) throws SpdxCompareException, InvalidSPDXAnalysisException {
        return SpdxComparer.stringsEqual((String)this.getFileValue(fileA), (String)this.getFileValue(fileB));
    }
}

