/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spdx.core.IModelCopyManager;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.library.ModelCopyManager;
import org.spdx.library.SpdxModelFactory;
import org.spdx.library.conversion.Spdx2to3Converter;
import org.spdx.library.model.v2.SpdxCreatorInformation;
import org.spdx.library.model.v2.SpdxDocument;
import org.spdx.library.model.v2.SpdxFile;
import org.spdx.library.model.v2.SpdxPackage;
import org.spdx.library.model.v2.SpdxSnippet;
import org.spdx.library.model.v3_0_1.SpdxConstantsV3;
import org.spdx.library.model.v3_0_1.core.CreationInfo;
import org.spdx.spdxRdfStore.RdfStore;
import org.spdx.storage.IModelStore;
import org.spdx.storage.ISerializableModelStore;
import org.spdx.tools.InvalidFileNameException;
import org.spdx.tools.SpdxConverterException;
import org.spdx.tools.SpdxToolsHelper;
import org.spdx.v3jsonldstore.JsonLDStore;

public class SpdxConverter {
    static final Logger logger = LoggerFactory.getLogger(SpdxConverter.class);
    static final int ERROR_STATUS = 1;
    static final int MIN_ARGS = 2;
    static final int MAX_ARGS = 5;

    public static void main(String[] args) {
        SpdxToolsHelper.initialize();
        if (args.length < 2) {
            System.err.println("Invalid number of arguments");
            SpdxConverter.usage();
            System.exit(1);
        }
        if (args.length > 5) {
            System.out.printf("Warning: Extra arguments will be ignored", new Object[0]);
        }
        if (args.length == 3) {
            System.out.printf("Warning: only the input file type specified - it will be ignored", new Object[0]);
        }
        boolean excludeLicenseDetails = false;
        if (args.length == 5 && "excludelicensedetails".equals(args[4].toLowerCase())) {
            excludeLicenseDetails = true;
        }
        if (args.length < 4) {
            try {
                SpdxConverter.convert(args[0], args[1]);
            }
            catch (SpdxConverterException e) {
                System.err.println("Error converting: " + e.getMessage());
                System.exit(1);
            }
        } else {
            SpdxToolsHelper.SerFileType fromFileType = null;
            try {
                fromFileType = SpdxToolsHelper.strToFileType(args[2]);
            }
            catch (IllegalArgumentException e) {
                System.err.println("From file type is not a valid SPDX file type: " + args[2]);
                SpdxConverter.usage();
                System.exit(1);
            }
            SpdxToolsHelper.SerFileType toFileType = null;
            try {
                toFileType = SpdxToolsHelper.strToFileType(args[3]);
            }
            catch (IllegalArgumentException e) {
                System.err.println("To file type is not a valid SPDX file type: " + args[3]);
                SpdxConverter.usage();
                System.exit(1);
            }
            try {
                SpdxConverter.convert(args[0], args[1], fromFileType, toFileType, excludeLicenseDetails);
            }
            catch (SpdxConverterException e) {
                System.err.println("Error converting: " + e.getMessage());
                System.exit(1);
            }
        }
    }

    public static void convert(String fromFilePath, String toFilePath) throws SpdxConverterException {
        SpdxToolsHelper.SerFileType toFileType;
        SpdxToolsHelper.SerFileType fromFileType;
        try {
            fromFileType = SpdxToolsHelper.fileToFileType(new File(fromFilePath));
        }
        catch (InvalidFileNameException e) {
            throw new SpdxConverterException("From file " + fromFilePath + " does not end with a valid SPDX file extension.");
        }
        try {
            toFileType = SpdxToolsHelper.fileToFileType(new File(toFilePath));
        }
        catch (InvalidFileNameException e) {
            throw new SpdxConverterException("To file " + toFilePath + " does not end with a valid SPDX file extension.");
        }
        SpdxConverter.convert(fromFilePath, toFilePath, fromFileType, toFileType);
    }

    public static void convert(String fromFilePath, String toFilePath, SpdxToolsHelper.SerFileType fromFileType, SpdxToolsHelper.SerFileType toFileType) throws SpdxConverterException {
        SpdxConverter.convert(fromFilePath, toFilePath, fromFileType, toFileType, false);
    }

    public static void convert(String fromFilePath, String toFilePath, SpdxToolsHelper.SerFileType fromFileType, SpdxToolsHelper.SerFileType toFileType, boolean excludeLicenseDetails) throws SpdxConverterException {
        FileOutputStream output;
        FileInputStream input;
        block33: {
            File fromFile = new File(fromFilePath);
            if (!fromFile.exists()) {
                throw new SpdxConverterException("Input file " + fromFilePath + " does not exist.");
            }
            File toFile = new File(toFilePath);
            if (toFile.exists()) {
                throw new SpdxConverterException("Output file " + toFilePath + " already exists.");
            }
            input = null;
            output = null;
            String oldXmlInputFactory = null;
            boolean propertySet = false;
            try {
                SpdxConstantsV3.SpdxMajorVersion toVersion;
                ISerializableModelStore fromStore = SpdxToolsHelper.fileTypeToStore(fromFileType);
                ISerializableModelStore toStore = SpdxToolsHelper.fileTypeToStore(toFileType);
                SpdxConstantsV3.SpdxMajorVersion fromVersion = fromStore instanceof JsonLDStore ? SpdxConstantsV3.SpdxMajorVersion.VERSION_3 : SpdxConstantsV3.SpdxMajorVersion.VERSION_2;
                SpdxConstantsV3.SpdxMajorVersion spdxMajorVersion = toVersion = toStore instanceof JsonLDStore ? SpdxConstantsV3.SpdxMajorVersion.VERSION_3 : SpdxConstantsV3.SpdxMajorVersion.VERSION_2;
                if (fromVersion == SpdxConstantsV3.SpdxMajorVersion.VERSION_3 && toVersion != SpdxConstantsV3.SpdxMajorVersion.VERSION_3) {
                    throw new SpdxConverterException("Can not convert from SPDX spec version 3 to previous versions");
                }
                if (fromStore instanceof RdfStore || toStore instanceof RdfStore) {
                    try {
                        oldXmlInputFactory = System.setProperty("javax.xml.stream.XMLInputFactory", "com.sun.xml.internal.stream.XMLInputFactoryImpl");
                        propertySet = true;
                    }
                    catch (SecurityException e) {
                        propertySet = false;
                    }
                }
                if (toStore instanceof JsonLDStore) {
                    ((JsonLDStore)toStore).setUseExternalListedElements(true);
                }
                input = new FileInputStream(fromFile);
                output = new FileOutputStream(toFile);
                fromStore.deSerialize((InputStream)input, false);
                if (fromVersion == SpdxConstantsV3.SpdxMajorVersion.VERSION_3) {
                    SpdxConverter.copyV3ToV3(fromStore, toStore, excludeLicenseDetails);
                } else if (toVersion == SpdxConstantsV3.SpdxMajorVersion.VERSION_3) {
                    SpdxConverter.copyV2ToV3(fromStore, toStore, excludeLicenseDetails);
                } else {
                    SpdxConverter.copyV2ToV2(fromStore, toStore, excludeLicenseDetails);
                }
                toStore.serialize((OutputStream)output);
                if (!propertySet) break block33;
            }
            catch (Exception ex) {
                try {
                    String msg = "Error converting SPDX file: " + ex.getClass().toString();
                    if (Objects.nonNull(ex.getMessage())) {
                        msg = msg + " " + ex.getMessage();
                    }
                    throw new SpdxConverterException(msg, ex);
                }
                catch (Throwable throwable) {
                    if (propertySet) {
                        if (Objects.isNull(oldXmlInputFactory)) {
                            System.clearProperty("javax.xml.stream.XMLInputFactory");
                        } else {
                            System.setProperty("javax.xml.stream.XMLInputFactory", oldXmlInputFactory);
                        }
                    }
                    if (Objects.nonNull(input)) {
                        try {
                            input.close();
                        }
                        catch (IOException e) {
                            logger.warn("Error closing input file: " + e.getMessage());
                        }
                    }
                    if (Objects.nonNull(output)) {
                        try {
                            output.close();
                        }
                        catch (IOException e) {
                            logger.warn("Error closing output file: " + e.getMessage());
                        }
                    }
                    throw throwable;
                }
            }
            if (Objects.isNull(oldXmlInputFactory)) {
                System.clearProperty("javax.xml.stream.XMLInputFactory");
            } else {
                System.setProperty("javax.xml.stream.XMLInputFactory", oldXmlInputFactory);
            }
        }
        if (Objects.nonNull(input)) {
            try {
                input.close();
            }
            catch (IOException e) {
                logger.warn("Error closing input file: " + e.getMessage());
            }
        }
        if (Objects.nonNull(output)) {
            try {
                output.close();
            }
            catch (IOException e) {
                logger.warn("Error closing output file: " + e.getMessage());
            }
        }
    }

    private static void copyV2ToV2(ISerializableModelStore fromStore, ISerializableModelStore toStore, boolean excludeLicenseDetails) throws InvalidSPDXAnalysisException {
        String documentUri = SpdxToolsHelper.getDocFromStoreCompatV2(fromStore).getDocumentUri();
        if (toStore instanceof RdfStore) {
            ((RdfStore)toStore).setDocumentUri(documentUri, false);
            ((RdfStore)toStore).setDontStoreLicenseDetails(excludeLicenseDetails);
        }
        ModelCopyManager copyManager = new ModelCopyManager();
        fromStore.getAllItems(documentUri, "ExternalDocumentRef").forEach(tv -> {
            try {
                copyManager.copy((IModelStore)toStore, (IModelStore)fromStore, tv.getObjectUri(), tv.getSpecVersion(), documentUri + "#");
            }
            catch (InvalidSPDXAnalysisException e) {
                throw new RuntimeException(e);
            }
        });
        fromStore.getAllItems(documentUri, null).forEach(tv -> {
            try {
                if (!("ExternalDocumentRef".equals(tv.getType()) || excludeLicenseDetails && "CrossRef".equals(tv.getType()))) {
                    copyManager.copy((IModelStore)toStore, (IModelStore)fromStore, tv.getObjectUri(), tv.getSpecVersion(), documentUri);
                }
            }
            catch (InvalidSPDXAnalysisException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private static void copyV2ToV3(ISerializableModelStore fromStore, ISerializableModelStore toStore, boolean excludeLicenseDetails) throws InvalidSPDXAnalysisException {
        ModelCopyManager copyManager = new ModelCopyManager();
        SpdxDocument fromDoc = SpdxToolsHelper.getDocFromStoreCompatV2(fromStore);
        String toUriPrefix = fromDoc.getDocumentUri() + "-specv3/";
        CreationInfo defaultCreationInfo = Spdx2to3Converter.convertCreationInfo((SpdxCreatorInformation)fromDoc.getCreationInfo(), (IModelStore)toStore, (String)toUriPrefix);
        Spdx2to3Converter converter = new Spdx2to3Converter((IModelStore)toStore, (IModelCopyManager)copyManager, defaultCreationInfo, SpdxModelFactory.getLatestSpecVersion(), toUriPrefix, !excludeLicenseDetails);
        converter.convertAndStore(fromDoc);
        SpdxModelFactory.getSpdxObjects((IModelStore)fromStore, (IModelCopyManager)copyManager, (String)"File", (String)fromDoc.getDocumentUri(), (String)fromDoc.getDocumentUri()).forEach(f -> {
            if (!converter.alreadyCopied(((SpdxFile)f).getObjectUri())) {
                try {
                    converter.convertAndStore((SpdxFile)f);
                }
                catch (InvalidSPDXAnalysisException e) {
                    throw new RuntimeException("Error upgrading file " + String.valueOf(f) + " from spec version 2 to spec version 3", e);
                }
            }
        });
        SpdxModelFactory.getSpdxObjects((IModelStore)fromStore, (IModelCopyManager)copyManager, (String)"Package", (String)fromDoc.getDocumentUri(), (String)fromDoc.getDocumentUri()).forEach(p -> {
            if (!converter.alreadyCopied(((SpdxPackage)p).getObjectUri())) {
                try {
                    converter.convertAndStore((SpdxPackage)p);
                }
                catch (InvalidSPDXAnalysisException e) {
                    throw new RuntimeException("Error upgrading package " + String.valueOf(p) + " from spec version 2 to spec version 3", e);
                }
            }
        });
        SpdxModelFactory.getSpdxObjects((IModelStore)fromStore, (IModelCopyManager)copyManager, (String)"Snippet", (String)fromDoc.getDocumentUri(), (String)fromDoc.getDocumentUri()).forEach(s -> {
            if (!converter.alreadyCopied(((SpdxSnippet)s).getObjectUri())) {
                try {
                    converter.convertAndStore((SpdxSnippet)s);
                }
                catch (InvalidSPDXAnalysisException e) {
                    throw new RuntimeException("Error upgrading snippet " + String.valueOf(s) + " from spec version 2 to spec version 3", e);
                }
            }
        });
    }

    private static void copyV3ToV3(ISerializableModelStore fromStore, ISerializableModelStore toStore, boolean excludeLicenseDetails) throws InvalidSPDXAnalysisException {
        ModelCopyManager copyManager = new ModelCopyManager();
        fromStore.getAllItems(null, null).forEach(tv -> {
            try {
                copyManager.copy((IModelStore)toStore, (IModelStore)fromStore, tv.getObjectUri(), tv.getSpecVersion(), null);
            }
            catch (InvalidSPDXAnalysisException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private static void usage() {
        System.out.println("Usage:");
        System.out.println("SpdxConverter fromFilePath toFilePath [fromFileType] [toFileType]");
        System.out.println("\tfromFilePath - File path of the file to convert from");
        System.out.println("\ttoFilePath - output file");
        System.out.println("\t[fromFileType] - optional file type of the input file.  One of JSON, XLS, XLSX, TAG, RDFXML, RDFTTL, YAML, XML or JSONLD.  If not provided the file type will be determined by the file extension");
        System.out.println("\t[toFileType] - optional file type of the output file.  One of JSON, XLS, XLSX, TAG, RDFXML, RDFTTL, YAML, XML or JSONLD.  If not provided the file type will be determined by the file extension");
        System.out.println("\t[excludeLicenseDetails] - If present, listed license and listed exception properties will not be included in the output file");
    }
}

