/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Scanner;
import java.util.stream.Collectors;
import org.spdx.core.CoreModelObject;
import org.spdx.core.DefaultModelStore;
import org.spdx.core.IModelCopyManager;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.jacksonstore.MultiFormatStore;
import org.spdx.library.ModelCopyManager;
import org.spdx.library.SpdxModelFactory;
import org.spdx.library.model.v2.SpdxDocument;
import org.spdx.spdxRdfStore.OutputFormat;
import org.spdx.spdxRdfStore.RdfStore;
import org.spdx.spreadsheetstore.SpreadsheetStore;
import org.spdx.storage.IModelStore;
import org.spdx.storage.ISerializableModelStore;
import org.spdx.storage.simple.InMemSpdxStore;
import org.spdx.tagvaluestore.TagValueStore;
import org.spdx.tools.InvalidFileNameException;
import org.spdx.v3jsonldstore.JsonLDStore;

public class SpdxToolsHelper {
    static final String XML_INPUT_FACTORY_PROPERTY_KEY = "javax.xml.stream.XMLInputFactory";
    static Map<String, SerFileType> EXT_TO_FILETYPE;

    public static ISerializableModelStore fileTypeToStore(SerFileType fileType) throws InvalidSPDXAnalysisException {
        switch (fileType.ordinal()) {
            case 0: {
                return new MultiFormatStore((IModelStore)new InMemSpdxStore(), MultiFormatStore.Format.JSON_PRETTY, MultiFormatStore.Verbose.COMPACT);
            }
            case 1: {
                RdfStore rdfStore = new RdfStore();
                rdfStore.setOutputFormat(OutputFormat.XML);
                return rdfStore;
            }
            case 7: {
                RdfStore rdfStore = new RdfStore();
                rdfStore.setOutputFormat(OutputFormat.TURTLE);
                return rdfStore;
            }
            case 6: {
                return new TagValueStore((IModelStore)new InMemSpdxStore());
            }
            case 3: {
                return new SpreadsheetStore((IModelStore)new InMemSpdxStore(), SpreadsheetStore.SpreadsheetFormatType.XLS);
            }
            case 4: {
                return new SpreadsheetStore((IModelStore)new InMemSpdxStore(), SpreadsheetStore.SpreadsheetFormatType.XLSX);
            }
            case 2: {
                return new MultiFormatStore((IModelStore)new InMemSpdxStore(), MultiFormatStore.Format.XML, MultiFormatStore.Verbose.COMPACT);
            }
            case 5: {
                return new MultiFormatStore((IModelStore)new InMemSpdxStore(), MultiFormatStore.Format.YAML, MultiFormatStore.Verbose.COMPACT);
            }
            case 8: {
                return new JsonLDStore((IModelStore)new InMemSpdxStore());
            }
        }
        throw new InvalidSPDXAnalysisException("Unsupported file type: " + String.valueOf((Object)fileType) + ".  Check back later.");
    }

    public static SerFileType fileToFileType(File file) throws InvalidFileNameException {
        SerFileType retval;
        String fileName = file.getName();
        if (!fileName.contains(".")) {
            throw new InvalidFileNameException("Can not convert file to file type - no file extension for file " + file.getPath());
        }
        String ext = fileName.substring(fileName.lastIndexOf(".") + 1).toLowerCase();
        if ("xml".equals(ext) && fileName.endsWith("rdf.xml")) {
            ext = "rdf.xml";
        }
        if ("ttl".equals(ext) && fileName.endsWith("rdf.ttl")) {
            ext = "rdf.ttl";
        }
        if ("json".equals(ext) && fileName.endsWith("jsonld.json")) {
            ext = "jsonld.json";
        }
        if (SerFileType.JSON.equals((Object)(retval = EXT_TO_FILETYPE.get(ext)))) {
            try (Scanner scanner = new Scanner(file);){
                scanner.useDelimiter("\"");
                boolean foundContext = false;
                boolean foundRdfUri = false;
                while (scanner.hasNext()) {
                    String line = scanner.next().toLowerCase();
                    if (line.contains("https://spdx.org/rdf/3.")) {
                        foundRdfUri = true;
                    }
                    if (line.contains("@context")) {
                        foundContext = true;
                    }
                    if (!foundContext || !foundRdfUri) continue;
                    retval = SerFileType.JSONLD;
                    break;
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        if (Objects.isNull((Object)retval)) {
            throw new InvalidFileNameException("Unrecognized file extension: " + ext + " for file " + file.getPath());
        }
        return retval;
    }

    public static SerFileType strToFileType(String str) {
        String strFileType = str.toUpperCase().trim();
        return SerFileType.valueOf(strFileType);
    }

    public static SpdxDocument deserializeDocumentCompatV2(File file) throws InvalidSPDXAnalysisException, IOException, InvalidFileNameException {
        ISerializableModelStore store = SpdxToolsHelper.fileTypeToStore(SpdxToolsHelper.fileToFileType(file));
        if (!SpdxToolsHelper.supportsV2(store)) {
            throw new RuntimeException("Store does not support SPDX version 2");
        }
        return SpdxToolsHelper.readDocumentFromFileCompatV2(store, file);
    }

    public static SpdxDocument deserializeDocumentCompatV2(File file, SerFileType fileType) throws InvalidSPDXAnalysisException, IOException {
        ISerializableModelStore store = SpdxToolsHelper.fileTypeToStore(fileType);
        if (!SpdxToolsHelper.supportsV2(store)) {
            throw new RuntimeException("Store does not support SPDX version 2");
        }
        return SpdxToolsHelper.readDocumentFromFileCompatV2(store, file);
    }

    public static org.spdx.library.model.v3_0_1.core.SpdxDocument deserializeDocumentCompat(File file) throws InvalidSPDXAnalysisException, IOException, InvalidFileNameException {
        ISerializableModelStore store = SpdxToolsHelper.fileTypeToStore(SpdxToolsHelper.fileToFileType(file));
        if (!SpdxToolsHelper.supportsV3(store)) {
            throw new RuntimeException("Store does not support SPDX version 3");
        }
        return SpdxToolsHelper.readDocumentFromFileV3(store, file);
    }

    public static org.spdx.library.model.v3_0_1.core.SpdxDocument deserializeDocument(File file, SerFileType fileType) throws InvalidSPDXAnalysisException, IOException {
        ISerializableModelStore store = SpdxToolsHelper.fileTypeToStore(fileType);
        if (!SpdxToolsHelper.supportsV3(store)) {
            throw new RuntimeException("Store does not support SPDX version 3");
        }
        return SpdxToolsHelper.readDocumentFromFileV3(store, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void deserializeFile(ISerializableModelStore store, File file) throws FileNotFoundException, IOException, InvalidSPDXAnalysisException {
        String oldXmlInputFactory = null;
        boolean propertySet = false;
        try {
            try (FileInputStream is = new FileInputStream(file);){
                if (store instanceof RdfStore) {
                    try {
                        oldXmlInputFactory = System.setProperty(XML_INPUT_FACTORY_PROPERTY_KEY, "com.sun.xml.internal.stream.XMLInputFactoryImpl");
                        propertySet = true;
                    }
                    catch (SecurityException e) {
                        propertySet = false;
                    }
                }
                store.deSerialize((InputStream)is, false);
            }
            if (!propertySet) return;
        }
        catch (Throwable throwable) {
            if (!propertySet) throw throwable;
            if (Objects.isNull(oldXmlInputFactory)) {
                System.clearProperty(XML_INPUT_FACTORY_PROPERTY_KEY);
                throw throwable;
            } else {
                System.setProperty(XML_INPUT_FACTORY_PROPERTY_KEY, oldXmlInputFactory);
            }
            throw throwable;
        }
        if (Objects.isNull(oldXmlInputFactory)) {
            System.clearProperty(XML_INPUT_FACTORY_PROPERTY_KEY);
            return;
        } else {
            System.setProperty(XML_INPUT_FACTORY_PROPERTY_KEY, oldXmlInputFactory);
        }
    }

    public static boolean supportsV3(ISerializableModelStore store) {
        return store instanceof JsonLDStore;
    }

    public static boolean supportsV2(ISerializableModelStore store) {
        return !(store instanceof JsonLDStore);
    }

    public static org.spdx.library.model.v3_0_1.core.SpdxDocument readDocumentFromFileV3(ISerializableModelStore store, File file) throws FileNotFoundException, IOException, InvalidSPDXAnalysisException {
        if (!SpdxToolsHelper.supportsV3(store)) {
            throw new RuntimeException("Store does not support SPDX version 3");
        }
        SpdxToolsHelper.deserializeFile(store, file);
        return SpdxToolsHelper.getDocFromStore(store);
    }

    public static CoreModelObject readDocumentFromFile(ISerializableModelStore store, File file) throws FileNotFoundException, IOException, InvalidSPDXAnalysisException {
        if (store instanceof JsonLDStore) {
            return SpdxToolsHelper.readDocumentFromFileV3(store, file);
        }
        return SpdxToolsHelper.readDocumentFromFileCompatV2(store, file);
    }

    public static SpdxDocument readDocumentFromFileCompatV2(ISerializableModelStore store, File file) throws FileNotFoundException, IOException, InvalidSPDXAnalysisException {
        if (!SpdxToolsHelper.supportsV2(store)) {
            throw new RuntimeException("Store does not support SPDX version 2");
        }
        SpdxToolsHelper.deserializeFile(store, file);
        return SpdxToolsHelper.getDocFromStoreCompatV2(store);
    }

    public static org.spdx.library.model.v3_0_1.core.SpdxDocument getDocFromStore(ISerializableModelStore store) throws InvalidSPDXAnalysisException {
        List docs = SpdxModelFactory.getSpdxObjects((IModelStore)store, null, (String)"Core.SpdxDocument", null, null).collect(Collectors.toList());
        if (docs.isEmpty()) {
            throw new InvalidSPDXAnalysisException("No SPDX version 3 documents in model store");
        }
        if (docs.size() > 1) {
            throw new InvalidSPDXAnalysisException("Multiple SPDX version 3 documents in modelStore.  There can only be one SPDX document.");
        }
        return (org.spdx.library.model.v3_0_1.core.SpdxDocument)docs.get(0);
    }

    public static SpdxDocument getDocFromStoreCompatV2(ISerializableModelStore store) throws InvalidSPDXAnalysisException {
        List docs = SpdxModelFactory.getSpdxObjects((IModelStore)store, null, (String)"SpdxDocument", null, null).collect(Collectors.toList());
        if (docs.isEmpty()) {
            throw new InvalidSPDXAnalysisException("No SPDX version 2 documents in model store");
        }
        if (docs.size() > 1) {
            throw new InvalidSPDXAnalysisException("Multiple SPDX version 2 documents in modelSTore.  There can only be one SPDX document.");
        }
        return (SpdxDocument)docs.get(0);
    }

    public static void initialize() {
        SpdxModelFactory.init();
        DefaultModelStore.initialize((IModelStore)new InMemSpdxStore(), (String)"https://spdx.org/documents/default", (IModelCopyManager)new ModelCopyManager());
    }

    static {
        HashMap<String, SerFileType> temp = new HashMap<String, SerFileType>();
        temp.put("jsonld.json", SerFileType.JSONLD);
        temp.put("jsonld", SerFileType.JSONLD);
        temp.put("json", SerFileType.JSON);
        temp.put("rdf.xml", SerFileType.RDFXML);
        temp.put("rdf", SerFileType.RDFXML);
        temp.put("xml", SerFileType.XML);
        temp.put("xls", SerFileType.XLS);
        temp.put("xlsx", SerFileType.XLSX);
        temp.put("yaml", SerFileType.YAML);
        temp.put("tag", SerFileType.TAG);
        temp.put("spdx", SerFileType.TAG);
        temp.put("yml", SerFileType.YAML);
        temp.put("rdf.ttl", SerFileType.RDFTTL);
        EXT_TO_FILETYPE = Collections.unmodifiableMap(temp);
    }

    public static enum SerFileType {
        JSON,
        RDFXML,
        XML,
        XLS,
        XLSX,
        YAML,
        TAG,
        RDFTTL,
        JSONLD;

    }
}

