/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.tools.compare;

import java.util.Collection;
import java.util.Iterator;
import org.apache.poi.ss.usermodel.Workbook;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.library.model.v2.SpdxFile;
import org.spdx.tools.compare.AbstractFileCompareSheet;
import org.spdx.utility.compare.SpdxCompareException;
import org.spdx.utility.compare.SpdxComparer;

public class FileAttributionSheet
extends AbstractFileCompareSheet {
    private static final int FILE_ATTRIBUTION_COL_WIDTH = 50;

    public FileAttributionSheet(Workbook workbook, String sheetName) {
        super(workbook, sheetName);
    }

    static void create(Workbook wb, String sheetName) {
        AbstractFileCompareSheet.create(wb, sheetName, 50);
    }

    @Override
    boolean valuesMatch(SpdxComparer comparer, SpdxFile fileA, int docIndexA, SpdxFile fileB, int docIndexB) throws SpdxCompareException, InvalidSPDXAnalysisException {
        return SpdxComparer.stringCollectionsEqual((Collection)fileA.getAttributionText(), (Collection)fileB.getAttributionText());
    }

    @Override
    String getFileValue(SpdxFile spdxFile) throws InvalidSPDXAnalysisException {
        StringBuilder sb = new StringBuilder();
        Collection attribution = spdxFile.getAttributionText();
        if (attribution != null && attribution.size() > 0) {
            Iterator iter = attribution.iterator();
            sb.append((String)iter.next());
            while (iter.hasNext()) {
                sb.append(", ");
                sb.append((String)iter.next());
            }
        }
        return sb.toString();
    }
}

