/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.tools.compare;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Optional;

public class NormalizedFileNameComparator
implements Comparator<Optional<String>>,
Serializable {
    private static final long serialVersionUID = 1L;
    static final char DOS_SEPARATOR = '\\';
    static final char UNIX_SEPARATOR = '/';
    static final String RELATIVE_DIR = "./";

    @Override
    public int compare(Optional<String> fileName1, Optional<String> fileName2) {
        String normalizedFileName1 = NormalizedFileNameComparator.normalizeFileName(fileName1);
        String normalizedFileName2 = NormalizedFileNameComparator.normalizeFileName(fileName2);
        return normalizedFileName1.compareTo(normalizedFileName2);
    }

    public static boolean hasLeadingDir(String fileName1, String fileName2) {
        String compareName1 = fileName1;
        String compareName2 = fileName2;
        if (compareName1.startsWith(RELATIVE_DIR)) {
            compareName1 = compareName1.substring(RELATIVE_DIR.length());
        }
        if (compareName2.startsWith(RELATIVE_DIR)) {
            compareName2 = compareName2.substring(RELATIVE_DIR.length());
        }
        if (compareName1.length() <= compareName2.length()) {
            return false;
        }
        if (!compareName1.endsWith(compareName2)) {
            return false;
        }
        char schar = compareName1.charAt(compareName1.length() - compareName2.length() - 1);
        return schar == '/';
    }

    public static String normalizeFileName(Optional<String> fileName) {
        if (!fileName.isPresent()) {
            return "[NO_NAME]";
        }
        Object retval = fileName.get().replace('\\', '/');
        if (!((String)retval).startsWith(RELATIVE_DIR)) {
            retval = RELATIVE_DIR + (String)retval;
        }
        return retval;
    }
}

