/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.tools.schema;

import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import org.apache.jena.ontology.Individual;
import org.apache.jena.ontology.OntClass;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.ontology.OntProperty;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaAnnotated;
import org.apache.ws.commons.schema.XmlSchemaAnnotation;
import org.apache.ws.commons.schema.XmlSchemaCollection;
import org.apache.ws.commons.schema.XmlSchemaComplexContent;
import org.apache.ws.commons.schema.XmlSchemaComplexContentExtension;
import org.apache.ws.commons.schema.XmlSchemaComplexType;
import org.apache.ws.commons.schema.XmlSchemaContent;
import org.apache.ws.commons.schema.XmlSchemaContentModel;
import org.apache.ws.commons.schema.XmlSchemaContentType;
import org.apache.ws.commons.schema.XmlSchemaDocumentation;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaEnumerationFacet;
import org.apache.ws.commons.schema.XmlSchemaForm;
import org.apache.ws.commons.schema.XmlSchemaParticle;
import org.apache.ws.commons.schema.XmlSchemaSequence;
import org.apache.ws.commons.schema.XmlSchemaSerializer;
import org.apache.ws.commons.schema.XmlSchemaSimpleType;
import org.apache.ws.commons.schema.XmlSchemaSimpleTypeContent;
import org.apache.ws.commons.schema.XmlSchemaSimpleTypeRestriction;
import org.apache.ws.commons.schema.XmlSchemaType;
import org.apache.ws.commons.schema.utils.NamespaceMap;
import org.apache.ws.commons.schema.utils.NamespacePrefixList;
import org.spdx.tools.schema.AbstractOwlRdfConverter;
import org.spdx.tools.schema.SchemaException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class OwlToXsd
extends AbstractOwlRdfConverter {
    XmlSchemaCollection schemas = new XmlSchemaCollection();

    public OwlToXsd(OntModel model) {
        super(model);
    }

    public XmlSchema convertToXsd() throws XmlSchemaSerializer.XmlSchemaSerializerException, SchemaException {
        if (!this.ontology.isURIResource()) {
            throw new SchemaException("Ontology is not a URI resource");
        }
        String nameSpace = this.ontology.getURI();
        XmlSchema schema = new XmlSchema(nameSpace, this.schemas);
        schema.setSchemaNamespacePrefix(nameSpace);
        schema.setInputEncoding(StandardCharsets.UTF_8.name());
        schema.setElementFormDefault(XmlSchemaForm.QUALIFIED);
        NamespaceMap namespaces = new NamespaceMap();
        namespaces.add("xs", "http://www.w3.org/2001/XMLSchema");
        schema.setNamespaceContext((NamespacePrefixList)namespaces);
        this.addDocumentation(schema, (XmlSchemaAnnotated)schema, this.ontology.getComment(null));
        ExtendedIterator classIter = this.model.listClasses().filterKeep(ontClass -> ontClass.isURIResource());
        while (classIter.hasNext()) {
            OntClass type = (OntClass)classIter.next();
            this.addTypeToSchema(schema, type);
        }
        XmlSchemaElement documentElement = new XmlSchemaElement(schema, true);
        documentElement.setName("Document");
        documentElement.setSchemaTypeName(new QName("http://spdx.org/rdf/terms#".substring(0, "http://spdx.org/rdf/terms#".length() - 1), "SpdxDocument"));
        this.addDocumentation(schema, (XmlSchemaAnnotated)documentElement, "Top level element for the SPDX document");
        return schema;
    }

    private void addTypeToSchema(XmlSchema schema, OntClass type) throws XmlSchemaSerializer.XmlSchemaSerializerException, SchemaException {
        ExtendedIterator individualIter = this.model.listIndividuals((Resource)type);
        if (individualIter.hasNext()) {
            this.addEnumTypeToSchema(schema, type, individualIter.toList());
        } else {
            this.addComplexTypeToSchema(schema, type);
        }
    }

    private XmlSchemaType addComplexTypeToSchema(XmlSchema schema, OntClass type) throws XmlSchemaSerializer.XmlSchemaSerializerException, SchemaException {
        XmlSchemaComplexType xmlType = new XmlSchemaComplexType(schema, true);
        xmlType.setName(type.getLocalName());
        this.addDocumentation(schema, (XmlSchemaAnnotated)xmlType, type.getComment(null));
        XmlSchemaComplexContentExtension schemaExtension = null;
        ExtendedIterator superClassIter = type.listSuperClasses(true).filterKeep(sc -> sc.isURIResource() && !"http://www.w3.org/2000/01/rdf-schema#Container".equals(sc.getURI()));
        if (superClassIter.hasNext()) {
            OntClass superClass = (OntClass)superClassIter.next();
            schemaExtension = new XmlSchemaComplexContentExtension();
            schemaExtension.setBaseTypeName(new QName("http://spdx.org/rdf/terms#".substring(0, "http://spdx.org/rdf/terms#".length() - 1), superClass.getLocalName()));
        }
        if (superClassIter.hasNext()) {
            throw new SchemaException("Ambiguous superclasses for " + type.getLocalName());
        }
        Collection<OntProperty> ontProperties = this.propertiesFromClassRestrictions(type, true);
        xmlType.setContentType(XmlSchemaContentType.ELEMENT_ONLY);
        XmlSchemaSequence sequence = new XmlSchemaSequence();
        for (OntProperty property : ontProperties) {
            if (SKIPPED_PROPERTIES.contains(property.getURI())) continue;
            AbstractOwlRdfConverter.PropertyRestrictions restrictions = this.getPropertyRestrictions(type, property);
            XmlSchemaElement propertyMember = new XmlSchemaElement(schema, false);
            propertyMember.setName(property.getLocalName());
            Optional<Resource> rdfType = this.getPropertyType(property);
            if (rdfType.isPresent()) {
                String typeNamespace = rdfType.get().getNameSpace().equals("http://www.w3.org/2009/pointers#") || rdfType.get().getNameSpace().equals("http://usefulinc.com/ns/doap#") ? "http://spdx.org/rdf/terms#".substring(0, "http://spdx.org/rdf/terms#".length() - 1) : rdfType.get().getNameSpace().substring(0, rdfType.get().getNameSpace().length() - 1);
                propertyMember.setSchemaTypeName(new QName(typeNamespace, rdfType.get().getLocalName()));
            }
            this.addDocumentation(schema, (XmlSchemaAnnotated)propertyMember, property.getComment(null));
            if (restrictions.isOptional()) {
                propertyMember.setMinOccurs(0L);
            } else {
                propertyMember.setMinOccurs(1L);
            }
            if (restrictions.isListProperty()) {
                if (restrictions.getMinCardinality() > -1) {
                    propertyMember.setMinOccurs((long)restrictions.getMinCardinality());
                }
                if (restrictions.getMaxCardinality() > -1) {
                    propertyMember.setMaxOccurs((long)restrictions.getMaxCardinality());
                } else {
                    propertyMember.setMaxOccurs(Long.MAX_VALUE);
                }
            } else {
                propertyMember.setMaxOccurs(1L);
            }
            sequence.getItems().add(propertyMember);
        }
        if (type.getLocalName().equals("SpdxElement")) {
            XmlSchemaElement propertyMember = new XmlSchemaElement(schema, false);
            propertyMember.setName("SPDXID");
            propertyMember.setSchemaTypeName(new QName("http://www.w3.org/2001/XMLSchema", "string"));
            sequence.getItems().add(propertyMember);
        }
        XmlSchemaComplexContent contentModel = new XmlSchemaComplexContent();
        if (Objects.nonNull(schemaExtension)) {
            if (sequence.getItems().size() > 0) {
                schemaExtension.setParticle((XmlSchemaParticle)sequence);
            }
            contentModel.setContent((XmlSchemaContent)schemaExtension);
            xmlType.setContentModel((XmlSchemaContentModel)contentModel);
        } else if (sequence.getItems().size() > 0) {
            xmlType.setParticle((XmlSchemaParticle)sequence);
        } else {
            xmlType.setAbstract(true);
        }
        return xmlType;
    }

    private void addEnumTypeToSchema(XmlSchema schema, OntClass type, List<Individual> individuals) throws XmlSchemaSerializer.XmlSchemaSerializerException {
        XmlSchemaSimpleType xmlType = new XmlSchemaSimpleType(schema, true);
        xmlType.setName(type.getLocalName());
        this.addDocumentation(schema, (XmlSchemaAnnotated)xmlType, type.getComment(null));
        XmlSchemaSimpleTypeRestriction xmlContent = new XmlSchemaSimpleTypeRestriction();
        xmlContent.setBaseTypeName(new QName("http://www.w3.org/2001/XMLSchema", "string"));
        for (Individual individual : individuals) {
            XmlSchemaEnumerationFacet xmlEnum = new XmlSchemaEnumerationFacet();
            xmlEnum.setValue((Object)individual.getLocalName());
            this.addDocumentation(schema, (XmlSchemaAnnotated)xmlEnum, individual.getComment(null));
            xmlContent.getFacets().add(xmlEnum);
        }
        xmlType.setContent((XmlSchemaSimpleTypeContent)xmlContent);
    }

    private void addDocumentation(XmlSchema schema, XmlSchemaAnnotated xmlSchemaObject, @Nullable String documentation) throws XmlSchemaSerializer.XmlSchemaSerializerException {
        Objects.requireNonNull(xmlSchemaObject);
        if (Objects.nonNull(documentation)) {
            XmlSchemaAnnotation annotation = new XmlSchemaAnnotation();
            XmlSchemaDocumentation schemaDoc = new XmlSchemaDocumentation();
            xmlSchemaObject.setAnnotation(annotation);
            final Text commentNode = schema.getSchemaDocument().createTextNode(documentation);
            NodeList markup = new NodeList(){
                final /* synthetic */ OwlToXsd this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public Node item(int index) {
                    if (index == 0) {
                        return commentNode;
                    }
                    return null;
                }

                @Override
                public int getLength() {
                    return 1;
                }
            };
            schemaDoc.setMarkup(markup);
            annotation.getItems().add(schemaDoc);
        }
    }
}

