/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.client2;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.http.HttpEntity;
import org.apache.http.entity.HttpEntityWrapper;

public abstract class ProgressListener {
    public abstract void onProgress(long var1, long var3);

    public long progressInterval() {
        return 500L;
    }

    public static class ProgressHttpEntity
    extends HttpEntityWrapper {
        private final ProgressListener listener;
        private final long length;

        public ProgressHttpEntity(HttpEntity wrapped, ProgressListener listener) {
            super(wrapped);
            this.listener = listener;
            this.length = wrapped.getContentLength();
        }

        public void writeTo(OutputStream out) throws IOException {
            this.wrappedEntity.writeTo((OutputStream)new CountingOutputStream(out));
        }

        private class CountingOutputStream
        extends FilterOutputStream {
            private long lastListened;
            private long intervalMs;
            private long transferred;

            public CountingOutputStream(OutputStream out) {
                super(out);
                this.lastListened = 0L;
                this.intervalMs = 0L;
                this.transferred = 0L;
                this.intervalMs = ProgressHttpEntity.this.listener.progressInterval();
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                this.out.write(b, off, len);
                this.transferred += (long)len;
                long now = System.currentTimeMillis();
                if (now - this.lastListened > this.intervalMs) {
                    this.lastListened = now;
                    ProgressHttpEntity.this.listener.onProgress(this.transferred, ProgressHttpEntity.this.length);
                }
            }

            @Override
            public void write(int b) throws IOException {
                super.write(b);
                ++this.transferred;
                long now = System.currentTimeMillis();
                if (now - this.lastListened > this.intervalMs) {
                    this.lastListened = now;
                    ProgressHttpEntity.this.listener.onProgress(this.transferred, ProgressHttpEntity.this.length);
                }
            }
        }
    }
}

