/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.client2.exception;

import com.dropbox.client2.exception.DropboxException;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;

public class DropboxServerException
extends DropboxException {
    public static final int _200_OK = 200;
    public static final int _302_FOUND = 302;
    public static final int _304_NOT_MODIFIED = 304;
    public static final int _400_BAD_REQUEST = 400;
    public static final int _401_UNAUTHORIZED = 401;
    public static final int _403_FORBIDDEN = 403;
    public static final int _404_NOT_FOUND = 404;
    public static final int _405_METHOD_NOT_ALLOWED = 405;
    public static final int _406_NOT_ACCEPTABLE = 406;
    public static final int _409_CONFLICT = 409;
    public static final int _411_LENGTH_REQUIRED = 411;
    public static final int _415_UNSUPPORTED_MEDIA = 415;
    public static final int _500_INTERNAL_SERVER_ERROR = 500;
    public static final int _501_NOT_IMPLEMENTED = 501;
    public static final int _502_BAD_GATEWAY = 502;
    public static final int _503_SERVICE_UNAVAILABLE = 503;
    public static final int _507_INSUFFICIENT_STORAGE = 507;
    private static final long serialVersionUID = 1L;
    public Error body;
    public int error;
    public String reason;
    public String server;
    public String location;
    public Map<String, Object> parsedResponse;

    public DropboxServerException(HttpResponse response) {
        this.fillInStackTrace();
        StatusLine status = response.getStatusLine();
        this.error = status.getStatusCode();
        this.reason = status.getReasonPhrase();
        this.server = DropboxServerException.getHeader(response, "server");
        this.location = DropboxServerException.getHeader(response, "location");
    }

    public DropboxServerException(HttpResponse response, Object rest) {
        this(response);
        if (rest != null && rest instanceof Map) {
            this.parsedResponse = (Map)rest;
            this.body = new Error(this.parsedResponse);
        }
    }

    public boolean isDuplicateAccount() {
        return this.error == 400 && this.body != null && this.body.error.contains("taken");
    }

    @Override
    public String toString() {
        return "DropboxServerException (" + this.server + "): " + this.error + " " + this.reason + " (" + this.body.error + ")";
    }

    public static boolean isValidWithNullBody(HttpResponse response) {
        int loc;
        String location;
        int code = response.getStatusLine().getStatusCode();
        return code == 302 ? (location = DropboxServerException.getHeader(response, "location")) != null && (loc = location.indexOf("://")) > -1 && (loc = (location = location.substring(loc + 3)).indexOf("/")) > -1 && (location = location.substring(0, loc)).toLowerCase().contains("dropbox.com") : code == 304;
    }

    private static String getHeader(HttpResponse response, String name) {
        String value = null;
        Header serverheader = response.getFirstHeader(name);
        if (serverheader != null) {
            value = serverheader.getValue();
        }
        return value;
    }

    public static class Error {
        public String error;
        public String userError;

        public Error(Map<String, Object> map) {
            if (map != null) {
                Object err = map.get("error");
                if (err instanceof String) {
                    this.error = (String)err;
                } else if (err instanceof Map) {
                    Map detail = (Map)err;
                    for (Object val : detail.values()) {
                        if (!(val instanceof String)) continue;
                        this.error = (String)val;
                    }
                }
                Object uerr = map.get("user_error");
                if (uerr instanceof String) {
                    this.userError = (String)uerr;
                }
            }
        }
    }
}

