/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.gencode;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import org.teasoft.honey.osql.autogen.GenBean;
import org.teasoft.honey.osql.autogen.GenConfig;
import org.teasoft.honey.osql.core.Logger;
import org.teasoft.honey.osql.name.NameUtil;
import org.teasoft.honey.osql.util.FileUtil;
import org.teasoft.honey.osql.util.StringUtil;

public class GenCode {
    private GenCode() {
    }

    public static void genRestRichWithCodeMsg(String tableName, String basePackageName, String constPackageName) {
        GenCode._genRestRich(tableName, basePackageName, true, constPackageName);
    }

    public static void genRestRichWithCodeMsg(String tableName, String basePackageName) {
        GenCode._genRestRich(tableName, basePackageName, true, null);
    }

    public static void genRestRich(String tableName, String basePackageName) {
        GenCode._genRestRich(tableName, basePackageName, false, null);
    }

    private static void _genRestRich(String tableName, String basePackageName, boolean isUseCodeMsg, String constPackageName) {
        String entityName = tableName;
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("entityName", entityName);
        map.put("packageName", basePackageName);
        if (constPackageName == null) {
            constPackageName = GenCode.class.getPackage().getName();
        }
        map.put("constPackageName", constPackageName);
        GenConfig config = new GenConfig();
        String templateBasePath = GenCode.class.getPackage().getName() + ".template";
        templateBasePath = templateBasePath.replace(".", File.separator);
        String basePath = config.getBaseDir() + basePackageName.replace(".", File.separator);
        String entityName1 = NameUtil.firstLetterToUpperCase((String)entityName);
        String restTempName = "Rest.java.template";
        if (isUseCodeMsg) {
            restTempName = "Rest2.java.template";
        }
        String templatePath = templateBasePath + File.separator + restTempName;
        String targetRestFilePath = basePath + File.separator + "rest" + File.separator + entityName1 + "Rest.java";
        GenCode.genFile(templatePath, map, targetRestFilePath);
        templatePath = templateBasePath + "\\Service.java.template";
        targetRestFilePath = basePath + "\\service\\" + entityName1 + "Service.java";
        GenCode.genFile(templatePath, map, targetRestFilePath);
        templatePath = templateBasePath + "\\ServiceImpl.java.template";
        targetRestFilePath = basePath + "\\serviceimpl\\" + entityName1 + "ServiceImpl.java";
        GenCode.genFile(templatePath, map, targetRestFilePath);
        config.setPackagePath(basePackageName + ".entity");
        GenBean genBean = new GenBean(config);
        config.setGenFieldFile(true);
        genBean.genSomeBeanFile(tableName);
    }

    public static void genOneJavabean(String tableName) {
        GenConfig config = new GenConfig();
        GenBean genBean = new GenBean(config);
        config.setGenFieldFile(true);
        genBean.genSomeBeanFile(tableName);
    }

    private static void genFile(String templatePath, Map<String, String> map, String targetFilePath) {
        String txt = GenCode.readTemplateFile(templatePath);
        txt = StringUtil.replaceWithMap((String)txt, map, (String)"#{", (String)"}");
        FileUtil.genFile((String)targetFilePath, (String)txt);
    }

    private static String readTemplateFile(String filePath) {
        StringBuilder stringBuilder = new StringBuilder();
        filePath = filePath.replace("\\", "/");
        try (InputStream inputStream = GenCode.class.getClassLoader().getResourceAsStream(filePath);
             BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
            String line;
            while ((line = reader.readLine()) != null) {
                stringBuilder.append(line).append("\n");
            }
        }
        catch (IOException e) {
            Logger.error((String)e.getMessage(), (Throwable)e);
        }
        return stringBuilder.toString();
    }
}

