/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.ndarray.index;

import org.tensorflow.ndarray.IllegalRankException;
import org.tensorflow.ndarray.NdArray;
import org.tensorflow.ndarray.NdArrays;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.ndarray.buffer.DataBuffers;
import org.tensorflow.ndarray.index.All;
import org.tensorflow.ndarray.index.At;
import org.tensorflow.ndarray.index.Ellipsis;
import org.tensorflow.ndarray.index.Hyperslab;
import org.tensorflow.ndarray.index.Index;
import org.tensorflow.ndarray.index.NewAxis;
import org.tensorflow.ndarray.index.Sequence;
import org.tensorflow.ndarray.index.Slice;
import org.tensorflow.ndarray.index.SliceFrom;
import org.tensorflow.ndarray.index.SliceTo;
import org.tensorflow.ndarray.index.Step;

public final class Indices {
    public static Index at(long coord) {
        return new At(coord, false);
    }

    public static Index at(NdArray<? extends Number> coord) {
        if (coord.rank() > 0) {
            throw new IllegalRankException("Only scalars are accepted as a value index");
        }
        return new At(coord.getObject(new long[0]).longValue(), false);
    }

    public static Index at(long coord, boolean keepDim) {
        return new At(coord, keepDim);
    }

    public static Index at(NdArray<? extends Number> coord, boolean keepDim) {
        if (coord.rank() > 0) {
            throw new IllegalRankException("Only scalars are accepted as a value index");
        }
        return new At(coord.getObject(new long[0]).longValue(), keepDim);
    }

    public static Index all() {
        return All.INSTANCE;
    }

    public static Index seq(long ... coords) {
        if (coords == null) {
            throw new IllegalArgumentException();
        }
        return new Sequence(NdArrays.wrap(Shape.of(coords.length), DataBuffers.of(coords, true, false)));
    }

    public static Index seq(NdArray<? extends Number> coords) {
        if (coords.rank() != 1) {
            throw new IllegalRankException("Only vectors are accepted as an element index");
        }
        return new Sequence(coords);
    }

    public static Index even() {
        return Indices.step(2L);
    }

    public static Index odd() {
        return Indices.sliceFrom(1L, 2L);
    }

    public static Index step(long stride) {
        return new Step(stride);
    }

    public static Index sliceFrom(long start) {
        return Indices.sliceFrom(start, 1L);
    }

    public static Index sliceFrom(long start, long stride) {
        return new SliceFrom(start, stride);
    }

    public static Index sliceTo(long end) {
        return Indices.sliceTo(end, 1L);
    }

    public static Index sliceTo(long end, long stride) {
        return new SliceTo(end, stride);
    }

    public static Index range(long start, long end) {
        return Indices.slice(start, end);
    }

    public static Index flip() {
        return Indices.slice(null, null, -1L);
    }

    public static Index hyperslab(long start, long stride, long count, long block) {
        return new Hyperslab(start, stride, count, block);
    }

    public static Index newAxis() {
        return NewAxis.INSTANCE;
    }

    public static Index ellipsis() {
        return Ellipsis.INSTANCE;
    }

    public static Index slice(long start, long end) {
        return Indices.slice(start, end, 1L);
    }

    public static Index slice(long start, long end, long stride) {
        return new Slice(start, end, stride);
    }

    public static Index slice(Long start, Long end) {
        return Indices.slice(start, end, 1L);
    }

    public static Index slice(Long start, Long end, long stride) {
        if (start == null && end == null) {
            if (stride == 1L) {
                return Indices.all();
            }
            return Indices.step(stride);
        }
        if (start == null) {
            return Indices.sliceTo(end, stride);
        }
        if (end == null) {
            return Indices.sliceFrom(start, stride);
        }
        return Indices.slice((long)start, (long)end, stride);
    }
}

