/*
 * Decompiled with CFR 0.152.
 */
package org.testifyproject.apache.http.impl.auth;

import org.testifyproject.apache.http.Header;
import org.testifyproject.apache.http.HttpRequest;
import org.testifyproject.apache.http.annotation.NotThreadSafe;
import org.testifyproject.apache.http.auth.AuthenticationException;
import org.testifyproject.apache.http.auth.Credentials;
import org.testifyproject.apache.http.impl.auth.GGSSchemeBase;
import org.testifyproject.apache.http.protocol.HttpContext;
import org.testifyproject.apache.http.util.Args;
import org.testifyproject.ietf.jgss.GSSException;
import org.testifyproject.ietf.jgss.Oid;

@NotThreadSafe
public class SPNegoScheme
extends GGSSchemeBase {
    private static final String SPNEGO_OID = "1.3.6.1.5.5.2";

    public SPNegoScheme(boolean stripPort) {
        super(stripPort);
    }

    public SPNegoScheme() {
        super(false);
    }

    public String getSchemeName() {
        return "Negotiate";
    }

    public Header authenticate(Credentials credentials, HttpRequest request, HttpContext context) throws AuthenticationException {
        return super.authenticate(credentials, request, context);
    }

    protected byte[] generateToken(byte[] input, String authServer) throws GSSException {
        return this.generateGSSToken(input, new Oid(SPNEGO_OID), authServer);
    }

    public String getParameter(String name) {
        Args.notNull(name, "Parameter name");
        return null;
    }

    public String getRealm() {
        return null;
    }

    public boolean isConnectionBased() {
        return true;
    }
}

