/*
 * Decompiled with CFR 0.152.
 */
package org.testifyproject.apache.http.impl.conn;

import java.net.InetAddress;
import org.testifyproject.apache.http.HttpException;
import org.testifyproject.apache.http.HttpHost;
import org.testifyproject.apache.http.HttpRequest;
import org.testifyproject.apache.http.annotation.Immutable;
import org.testifyproject.apache.http.client.config.RequestConfig;
import org.testifyproject.apache.http.client.protocol.HttpClientContext;
import org.testifyproject.apache.http.conn.SchemePortResolver;
import org.testifyproject.apache.http.conn.UnsupportedSchemeException;
import org.testifyproject.apache.http.conn.routing.HttpRoute;
import org.testifyproject.apache.http.conn.routing.HttpRoutePlanner;
import org.testifyproject.apache.http.impl.conn.DefaultSchemePortResolver;
import org.testifyproject.apache.http.protocol.HttpContext;
import org.testifyproject.apache.http.util.Args;

@Immutable
public class DefaultRoutePlanner
implements HttpRoutePlanner {
    private final SchemePortResolver schemePortResolver;

    public DefaultRoutePlanner(SchemePortResolver schemePortResolver) {
        this.schemePortResolver = schemePortResolver != null ? schemePortResolver : DefaultSchemePortResolver.INSTANCE;
    }

    public HttpRoute determineRoute(HttpHost host, HttpRequest request, HttpContext context) throws HttpException {
        HttpHost target;
        Args.notNull(host, "Target host");
        Args.notNull(request, "Request");
        HttpClientContext clientContext = HttpClientContext.adapt(context);
        RequestConfig config = clientContext.getRequestConfig();
        InetAddress local = config.getLocalAddress();
        HttpHost proxy = config.getProxy();
        if (proxy == null) {
            proxy = this.determineProxy(host, request, context);
        }
        if (host.getPort() <= 0) {
            try {
                target = new HttpHost(host.getHostName(), this.schemePortResolver.resolve(host), host.getSchemeName());
            }
            catch (UnsupportedSchemeException ex) {
                throw new HttpException(ex.getMessage());
            }
        } else {
            target = host;
        }
        boolean secure = target.getSchemeName().equalsIgnoreCase("https");
        if (proxy == null) {
            return new HttpRoute(target, local, secure);
        }
        return new HttpRoute(target, local, proxy, secure);
    }

    protected HttpHost determineProxy(HttpHost target, HttpRequest request, HttpContext context) throws HttpException {
        return null;
    }
}

