/*
 * Decompiled with CFR 0.152.
 */
package org.testifyproject.apache.http.impl.cookie;

import java.util.Date;
import org.testifyproject.apache.http.annotation.Immutable;
import org.testifyproject.apache.http.cookie.MalformedCookieException;
import org.testifyproject.apache.http.cookie.SetCookie;
import org.testifyproject.apache.http.impl.cookie.AbstractCookieAttributeHandler;
import org.testifyproject.apache.http.util.Args;

@Immutable
public class BasicMaxAgeHandler
extends AbstractCookieAttributeHandler {
    public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        int age;
        Args.notNull(cookie, "Cookie");
        if (value == null) {
            throw new MalformedCookieException("Missing value for max-age attribute");
        }
        try {
            age = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new MalformedCookieException("Invalid max-age attribute: " + value);
        }
        if (age < 0) {
            throw new MalformedCookieException("Negative max-age attribute: " + value);
        }
        cookie.setExpiryDate(new Date(System.currentTimeMillis() + (long)age * 1000L));
    }
}

