/*
 * Decompiled with CFR 0.152.
 */
package org.testifyproject.apache.http.protocol;

import java.io.IOException;
import org.testifyproject.apache.http.HttpEntityEnclosingRequest;
import org.testifyproject.apache.http.HttpException;
import org.testifyproject.apache.http.HttpRequest;
import org.testifyproject.apache.http.HttpRequestInterceptor;
import org.testifyproject.apache.http.annotation.ThreadSafe;
import org.testifyproject.apache.http.protocol.HttpContext;
import org.testifyproject.apache.http.protocol.HttpDateGenerator;
import org.testifyproject.apache.http.util.Args;

@ThreadSafe
public class RequestDate
implements HttpRequestInterceptor {
    private static final HttpDateGenerator DATE_GENERATOR = new HttpDateGenerator();

    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (request instanceof HttpEntityEnclosingRequest && !request.containsHeader("Date")) {
            String httpdate = DATE_GENERATOR.getCurrentDate();
            request.setHeader("Date", httpdate);
        }
    }
}

