/*
 * Decompiled with CFR 0.152.
 */
package org.testifyproject.apache.http.protocol;

import java.io.IOException;
import java.net.InetAddress;
import org.testifyproject.apache.http.HttpConnection;
import org.testifyproject.apache.http.HttpException;
import org.testifyproject.apache.http.HttpHost;
import org.testifyproject.apache.http.HttpInetConnection;
import org.testifyproject.apache.http.HttpRequest;
import org.testifyproject.apache.http.HttpRequestInterceptor;
import org.testifyproject.apache.http.HttpVersion;
import org.testifyproject.apache.http.ProtocolException;
import org.testifyproject.apache.http.ProtocolVersion;
import org.testifyproject.apache.http.annotation.Immutable;
import org.testifyproject.apache.http.protocol.HttpContext;
import org.testifyproject.apache.http.protocol.HttpCoreContext;
import org.testifyproject.apache.http.util.Args;

@Immutable
public class RequestTargetHost
implements HttpRequestInterceptor {
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        HttpCoreContext corecontext = HttpCoreContext.adapt(context);
        ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
        String method = request.getRequestLine().getMethod();
        if (method.equalsIgnoreCase("CONNECT") && ver.lessEquals(HttpVersion.HTTP_1_0)) {
            return;
        }
        if (!request.containsHeader("Host")) {
            HttpHost targethost = corecontext.getTargetHost();
            if (targethost == null) {
                HttpConnection conn = corecontext.getConnection();
                if (conn instanceof HttpInetConnection) {
                    InetAddress address = ((HttpInetConnection)conn).getRemoteAddress();
                    int port = ((HttpInetConnection)conn).getRemotePort();
                    if (address != null) {
                        targethost = new HttpHost(address.getHostName(), port);
                    }
                }
                if (targethost == null) {
                    if (ver.lessEquals(HttpVersion.HTTP_1_0)) {
                        return;
                    }
                    throw new ProtocolException("Target host missing");
                }
            }
            request.addHeader("Host", targethost.toHostString());
        }
    }
}

