/*
 * Decompiled with CFR 0.152.
 */
package org.testifyproject.bouncycastle.asn1.cms.ecc;

import org.testifyproject.bouncycastle.asn1.ASN1EncodableVector;
import org.testifyproject.bouncycastle.asn1.ASN1Object;
import org.testifyproject.bouncycastle.asn1.ASN1OctetString;
import org.testifyproject.bouncycastle.asn1.ASN1Primitive;
import org.testifyproject.bouncycastle.asn1.ASN1Sequence;
import org.testifyproject.bouncycastle.asn1.ASN1TaggedObject;
import org.testifyproject.bouncycastle.asn1.DERSequence;
import org.testifyproject.bouncycastle.asn1.DERTaggedObject;
import org.testifyproject.bouncycastle.asn1.cms.OriginatorPublicKey;

public class MQVuserKeyingMaterial
extends ASN1Object {
    private OriginatorPublicKey ephemeralPublicKey;
    private ASN1OctetString addedukm;

    public MQVuserKeyingMaterial(OriginatorPublicKey originatorPublicKey, ASN1OctetString aSN1OctetString) {
        this.ephemeralPublicKey = originatorPublicKey;
        this.addedukm = aSN1OctetString;
    }

    private MQVuserKeyingMaterial(ASN1Sequence aSN1Sequence) {
        this.ephemeralPublicKey = OriginatorPublicKey.getInstance(aSN1Sequence.getObjectAt(0));
        if (aSN1Sequence.size() > 1) {
            this.addedukm = ASN1OctetString.getInstance((ASN1TaggedObject)aSN1Sequence.getObjectAt(1), true);
        }
    }

    public static MQVuserKeyingMaterial getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return MQVuserKeyingMaterial.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl));
    }

    public static MQVuserKeyingMaterial getInstance(Object object) {
        if (object == null || object instanceof MQVuserKeyingMaterial) {
            return (MQVuserKeyingMaterial)object;
        }
        if (object instanceof ASN1Sequence) {
            return new MQVuserKeyingMaterial((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("Invalid MQVuserKeyingMaterial: " + object.getClass().getName());
    }

    public OriginatorPublicKey getEphemeralPublicKey() {
        return this.ephemeralPublicKey;
    }

    public ASN1OctetString getAddedukm() {
        return this.addedukm;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.ephemeralPublicKey);
        if (this.addedukm != null) {
            aSN1EncodableVector.add(new DERTaggedObject(true, 0, this.addedukm));
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

