/*
 * Decompiled with CFR 0.152.
 */
package org.testifyproject.bouncycastle.cms;

import org.testifyproject.bouncycastle.asn1.ASN1OctetString;
import org.testifyproject.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.testifyproject.bouncycastle.asn1.cms.KeyTransRecipientInfo;
import org.testifyproject.bouncycastle.asn1.cms.RecipientIdentifier;
import org.testifyproject.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.testifyproject.bouncycastle.cms.AuthAttributesProvider;
import org.testifyproject.bouncycastle.cms.CMSException;
import org.testifyproject.bouncycastle.cms.CMSSecureReadable;
import org.testifyproject.bouncycastle.cms.KeyTransRecipient;
import org.testifyproject.bouncycastle.cms.KeyTransRecipientId;
import org.testifyproject.bouncycastle.cms.Recipient;
import org.testifyproject.bouncycastle.cms.RecipientInformation;
import org.testifyproject.bouncycastle.cms.RecipientOperator;

public class KeyTransRecipientInformation
extends RecipientInformation {
    private KeyTransRecipientInfo info;

    KeyTransRecipientInformation(KeyTransRecipientInfo keyTransRecipientInfo, AlgorithmIdentifier algorithmIdentifier, CMSSecureReadable cMSSecureReadable, AuthAttributesProvider authAttributesProvider) {
        super(keyTransRecipientInfo.getKeyEncryptionAlgorithm(), algorithmIdentifier, cMSSecureReadable, authAttributesProvider);
        this.info = keyTransRecipientInfo;
        RecipientIdentifier recipientIdentifier = keyTransRecipientInfo.getRecipientIdentifier();
        if (recipientIdentifier.isTagged()) {
            ASN1OctetString aSN1OctetString = ASN1OctetString.getInstance(recipientIdentifier.getId());
            this.rid = new KeyTransRecipientId(aSN1OctetString.getOctets());
        } else {
            IssuerAndSerialNumber issuerAndSerialNumber = IssuerAndSerialNumber.getInstance(recipientIdentifier.getId());
            this.rid = new KeyTransRecipientId(issuerAndSerialNumber.getName(), issuerAndSerialNumber.getSerialNumber().getValue());
        }
    }

    protected RecipientOperator getRecipientOperator(Recipient recipient) throws CMSException {
        return ((KeyTransRecipient)recipient).getRecipientOperator(this.keyEncAlg, this.messageAlgorithm, this.info.getEncryptedKey().getOctets());
    }
}

