/*
 * Decompiled with CFR 0.152.
 */
package org.testifyproject.bouncycastle.cms;

import java.util.ArrayList;
import java.util.Enumeration;
import org.testifyproject.bouncycastle.asn1.ASN1Encodable;
import org.testifyproject.bouncycastle.asn1.ASN1Primitive;
import org.testifyproject.bouncycastle.asn1.ASN1Sequence;
import org.testifyproject.bouncycastle.asn1.ASN1Set;
import org.testifyproject.bouncycastle.asn1.cms.OriginatorInfo;
import org.testifyproject.bouncycastle.asn1.x509.Certificate;
import org.testifyproject.bouncycastle.asn1.x509.CertificateList;
import org.testifyproject.bouncycastle.cert.X509CRLHolder;
import org.testifyproject.bouncycastle.cert.X509CertificateHolder;
import org.testifyproject.bouncycastle.util.CollectionStore;
import org.testifyproject.bouncycastle.util.Store;

public class OriginatorInformation {
    private OriginatorInfo originatorInfo;

    OriginatorInformation(OriginatorInfo originatorInfo) {
        this.originatorInfo = originatorInfo;
    }

    public Store getCertificates() {
        ASN1Set aSN1Set = this.originatorInfo.getCertificates();
        if (aSN1Set != null) {
            ArrayList<X509CertificateHolder> arrayList = new ArrayList<X509CertificateHolder>(aSN1Set.size());
            Enumeration enumeration = aSN1Set.getObjects();
            while (enumeration.hasMoreElements()) {
                ASN1Primitive aSN1Primitive = ((ASN1Encodable)enumeration.nextElement()).toASN1Primitive();
                if (!(aSN1Primitive instanceof ASN1Sequence)) continue;
                arrayList.add(new X509CertificateHolder(Certificate.getInstance(aSN1Primitive)));
            }
            return new CollectionStore(arrayList);
        }
        return new CollectionStore(new ArrayList());
    }

    public Store getCRLs() {
        ASN1Set aSN1Set = this.originatorInfo.getCRLs();
        if (aSN1Set != null) {
            ArrayList<X509CRLHolder> arrayList = new ArrayList<X509CRLHolder>(aSN1Set.size());
            Enumeration enumeration = aSN1Set.getObjects();
            while (enumeration.hasMoreElements()) {
                ASN1Primitive aSN1Primitive = ((ASN1Encodable)enumeration.nextElement()).toASN1Primitive();
                if (!(aSN1Primitive instanceof ASN1Sequence)) continue;
                arrayList.add(new X509CRLHolder(CertificateList.getInstance(aSN1Primitive)));
            }
            return new CollectionStore(arrayList);
        }
        return new CollectionStore(new ArrayList());
    }

    public OriginatorInfo toASN1Structure() {
        return this.originatorInfo;
    }
}

