/*
 * Decompiled with CFR 0.152.
 */
package org.testifyproject.bouncycastle.cms;

import org.testifyproject.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.testifyproject.bouncycastle.cert.X509CertificateHolder;
import org.testifyproject.bouncycastle.cms.CMSSignatureAlgorithmNameGenerator;
import org.testifyproject.bouncycastle.operator.ContentVerifier;
import org.testifyproject.bouncycastle.operator.ContentVerifierProvider;
import org.testifyproject.bouncycastle.operator.DigestCalculator;
import org.testifyproject.bouncycastle.operator.DigestCalculatorProvider;
import org.testifyproject.bouncycastle.operator.OperatorCreationException;
import org.testifyproject.bouncycastle.operator.SignatureAlgorithmIdentifierFinder;

public class SignerInformationVerifier {
    private ContentVerifierProvider verifierProvider;
    private DigestCalculatorProvider digestProvider;
    private SignatureAlgorithmIdentifierFinder sigAlgorithmFinder;
    private CMSSignatureAlgorithmNameGenerator sigNameGenerator;

    public SignerInformationVerifier(CMSSignatureAlgorithmNameGenerator cMSSignatureAlgorithmNameGenerator, SignatureAlgorithmIdentifierFinder signatureAlgorithmIdentifierFinder, ContentVerifierProvider contentVerifierProvider, DigestCalculatorProvider digestCalculatorProvider) {
        this.sigNameGenerator = cMSSignatureAlgorithmNameGenerator;
        this.sigAlgorithmFinder = signatureAlgorithmIdentifierFinder;
        this.verifierProvider = contentVerifierProvider;
        this.digestProvider = digestCalculatorProvider;
    }

    public boolean hasAssociatedCertificate() {
        return this.verifierProvider.hasAssociatedCertificate();
    }

    public X509CertificateHolder getAssociatedCertificate() {
        return this.verifierProvider.getAssociatedCertificate();
    }

    public ContentVerifier getContentVerifier(AlgorithmIdentifier algorithmIdentifier, AlgorithmIdentifier algorithmIdentifier2) throws OperatorCreationException {
        String string = this.sigNameGenerator.getSignatureName(algorithmIdentifier2, algorithmIdentifier);
        return this.verifierProvider.get(this.sigAlgorithmFinder.find(string));
    }

    public DigestCalculator getDigestCalculator(AlgorithmIdentifier algorithmIdentifier) throws OperatorCreationException {
        return this.digestProvider.get(algorithmIdentifier);
    }
}

