/*
 * Decompiled with CFR 0.152.
 */
package org.testifyproject.bouncycastle.cms.bc;

import org.testifyproject.bouncycastle.asn1.ASN1OctetString;
import org.testifyproject.bouncycastle.asn1.pkcs.PBKDF2Params;
import org.testifyproject.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.testifyproject.bouncycastle.cms.CMSException;
import org.testifyproject.bouncycastle.cms.PasswordRecipient;
import org.testifyproject.bouncycastle.cms.bc.EnvelopedDataHelper;
import org.testifyproject.bouncycastle.crypto.InvalidCipherTextException;
import org.testifyproject.bouncycastle.crypto.Wrapper;
import org.testifyproject.bouncycastle.crypto.generators.PKCS5S2ParametersGenerator;
import org.testifyproject.bouncycastle.crypto.params.KeyParameter;
import org.testifyproject.bouncycastle.crypto.params.ParametersWithIV;

public abstract class BcPasswordRecipient
implements PasswordRecipient {
    private int schemeID = 1;
    private char[] password;

    BcPasswordRecipient(char[] cArray) {
        this.password = cArray;
    }

    public BcPasswordRecipient setPasswordConversionScheme(int n) {
        this.schemeID = n;
        return this;
    }

    protected KeyParameter extractSecretKey(AlgorithmIdentifier algorithmIdentifier, AlgorithmIdentifier algorithmIdentifier2, byte[] byArray, byte[] byArray2) throws CMSException {
        Wrapper wrapper = EnvelopedDataHelper.createRFC3211Wrapper(algorithmIdentifier.getAlgorithm());
        wrapper.init(false, new ParametersWithIV(new KeyParameter(byArray), ASN1OctetString.getInstance(algorithmIdentifier.getParameters()).getOctets()));
        try {
            return new KeyParameter(wrapper.unwrap(byArray2, 0, byArray2.length));
        }
        catch (InvalidCipherTextException invalidCipherTextException) {
            throw new CMSException("unable to unwrap key: " + invalidCipherTextException.getMessage(), invalidCipherTextException);
        }
    }

    public byte[] calculateDerivedKey(byte[] byArray, AlgorithmIdentifier algorithmIdentifier, int n) throws CMSException {
        PBKDF2Params pBKDF2Params = PBKDF2Params.getInstance(algorithmIdentifier.getParameters());
        PKCS5S2ParametersGenerator pKCS5S2ParametersGenerator = new PKCS5S2ParametersGenerator();
        pKCS5S2ParametersGenerator.init(byArray, pBKDF2Params.getSalt(), pBKDF2Params.getIterationCount().intValue());
        return ((KeyParameter)pKCS5S2ParametersGenerator.generateDerivedParameters(n)).getKey();
    }

    public int getPasswordConversionScheme() {
        return this.schemeID;
    }

    public char[] getPassword() {
        return this.password;
    }
}

