/*
 * Decompiled with CFR 0.152.
 */
package org.testifyproject.bouncycastle.cms.jcajce;

import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import java.util.ArrayList;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.KeyAgreement;
import javax.crypto.SecretKey;
import org.testifyproject.bouncycastle.asn1.ASN1Encodable;
import org.testifyproject.bouncycastle.asn1.ASN1EncodableVector;
import org.testifyproject.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.testifyproject.bouncycastle.asn1.ASN1Sequence;
import org.testifyproject.bouncycastle.asn1.DEROctetString;
import org.testifyproject.bouncycastle.asn1.DERSequence;
import org.testifyproject.bouncycastle.asn1.cms.KeyAgreeRecipientIdentifier;
import org.testifyproject.bouncycastle.asn1.cms.RecipientEncryptedKey;
import org.testifyproject.bouncycastle.asn1.cms.RecipientKeyIdentifier;
import org.testifyproject.bouncycastle.asn1.cms.ecc.MQVuserKeyingMaterial;
import org.testifyproject.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.testifyproject.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.testifyproject.bouncycastle.cms.CMSAlgorithm;
import org.testifyproject.bouncycastle.cms.CMSEnvelopedGenerator;
import org.testifyproject.bouncycastle.cms.CMSException;
import org.testifyproject.bouncycastle.cms.KeyAgreeRecipientInfoGenerator;
import org.testifyproject.bouncycastle.cms.jcajce.CMSUtils;
import org.testifyproject.bouncycastle.cms.jcajce.DefaultJcaJceExtHelper;
import org.testifyproject.bouncycastle.cms.jcajce.EnvelopedDataHelper;
import org.testifyproject.bouncycastle.cms.jcajce.NamedJcaJceExtHelper;
import org.testifyproject.bouncycastle.cms.jcajce.ProviderJcaJceExtHelper;
import org.testifyproject.bouncycastle.jce.spec.MQVPrivateKeySpec;
import org.testifyproject.bouncycastle.jce.spec.MQVPublicKeySpec;
import org.testifyproject.bouncycastle.operator.GenericKey;

public class JceKeyAgreeRecipientInfoGenerator
extends KeyAgreeRecipientInfoGenerator {
    private List recipientIDs = new ArrayList();
    private List recipientKeys = new ArrayList();
    private PublicKey senderPublicKey;
    private PrivateKey senderPrivateKey;
    private EnvelopedDataHelper helper = new EnvelopedDataHelper(new DefaultJcaJceExtHelper());
    private SecureRandom random;
    private KeyPair ephemeralKP;

    public JceKeyAgreeRecipientInfoGenerator(ASN1ObjectIdentifier aSN1ObjectIdentifier, PrivateKey privateKey, PublicKey publicKey, ASN1ObjectIdentifier aSN1ObjectIdentifier2) {
        super(aSN1ObjectIdentifier, SubjectPublicKeyInfo.getInstance(publicKey.getEncoded()), aSN1ObjectIdentifier2);
        this.senderPublicKey = publicKey;
        this.senderPrivateKey = privateKey;
    }

    public JceKeyAgreeRecipientInfoGenerator setProvider(Provider provider) {
        this.helper = new EnvelopedDataHelper(new ProviderJcaJceExtHelper(provider));
        return this;
    }

    public JceKeyAgreeRecipientInfoGenerator setProvider(String string) {
        this.helper = new EnvelopedDataHelper(new NamedJcaJceExtHelper(string));
        return this;
    }

    public JceKeyAgreeRecipientInfoGenerator setSecureRandom(SecureRandom secureRandom) {
        this.random = secureRandom;
        return this;
    }

    public JceKeyAgreeRecipientInfoGenerator addRecipient(X509Certificate x509Certificate) throws CertificateEncodingException {
        this.recipientIDs.add(new KeyAgreeRecipientIdentifier(CMSUtils.getIssuerAndSerialNumber(x509Certificate)));
        this.recipientKeys.add(x509Certificate.getPublicKey());
        return this;
    }

    public JceKeyAgreeRecipientInfoGenerator addRecipient(byte[] byArray, PublicKey publicKey) throws CertificateEncodingException {
        this.recipientIDs.add(new KeyAgreeRecipientIdentifier(new RecipientKeyIdentifier(byArray)));
        this.recipientKeys.add(publicKey);
        return this;
    }

    public ASN1Sequence generateRecipientEncryptedKeys(AlgorithmIdentifier algorithmIdentifier, AlgorithmIdentifier algorithmIdentifier2, GenericKey genericKey) throws CMSException {
        this.init(algorithmIdentifier.getAlgorithm());
        PrivateKey privateKey = this.senderPrivateKey;
        ASN1ObjectIdentifier aSN1ObjectIdentifier = algorithmIdentifier.getAlgorithm();
        if (aSN1ObjectIdentifier.getId().equals(CMSEnvelopedGenerator.ECMQV_SHA1KDF)) {
            privateKey = new MQVPrivateKeySpec(privateKey, this.ephemeralKP.getPrivate(), this.ephemeralKP.getPublic());
        }
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        for (int i = 0; i != this.recipientIDs.size(); ++i) {
            PublicKey publicKey = (PublicKey)this.recipientKeys.get(i);
            KeyAgreeRecipientIdentifier keyAgreeRecipientIdentifier = (KeyAgreeRecipientIdentifier)this.recipientIDs.get(i);
            if (aSN1ObjectIdentifier.getId().equals(CMSEnvelopedGenerator.ECMQV_SHA1KDF)) {
                publicKey = new MQVPublicKeySpec(publicKey, publicKey);
            }
            try {
                KeyAgreement keyAgreement = this.helper.createKeyAgreement(aSN1ObjectIdentifier);
                keyAgreement.init((Key)privateKey, this.random);
                keyAgreement.doPhase(publicKey, true);
                SecretKey secretKey = keyAgreement.generateSecret(algorithmIdentifier2.getAlgorithm().getId());
                Cipher cipher = this.helper.createCipher(algorithmIdentifier2.getAlgorithm());
                cipher.init(3, (Key)secretKey, this.random);
                byte[] byArray = cipher.wrap(this.helper.getJceKey(genericKey));
                DEROctetString dEROctetString = new DEROctetString(byArray);
                aSN1EncodableVector.add(new RecipientEncryptedKey(keyAgreeRecipientIdentifier, dEROctetString));
                continue;
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new CMSException("cannot perform agreement step: " + generalSecurityException.getMessage(), generalSecurityException);
            }
        }
        return new DERSequence(aSN1EncodableVector);
    }

    protected ASN1Encodable getUserKeyingMaterial(AlgorithmIdentifier algorithmIdentifier) throws CMSException {
        this.init(algorithmIdentifier.getAlgorithm());
        if (this.ephemeralKP != null) {
            return new MQVuserKeyingMaterial(this.createOriginatorPublicKey(SubjectPublicKeyInfo.getInstance(this.ephemeralKP.getPublic().getEncoded())), null);
        }
        return null;
    }

    private void init(ASN1ObjectIdentifier aSN1ObjectIdentifier) throws CMSException {
        if (this.random == null) {
            this.random = new SecureRandom();
        }
        if (aSN1ObjectIdentifier.equals(CMSAlgorithm.ECMQV_SHA1KDF) && this.ephemeralKP == null) {
            try {
                ECParameterSpec eCParameterSpec = ((ECPublicKey)this.senderPublicKey).getParams();
                KeyPairGenerator keyPairGenerator = this.helper.createKeyPairGenerator(aSN1ObjectIdentifier);
                keyPairGenerator.initialize(eCParameterSpec, this.random);
                this.ephemeralKP = keyPairGenerator.generateKeyPair();
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                throw new CMSException("cannot determine MQV ephemeral key pair parameters from public key: " + invalidAlgorithmParameterException);
            }
        }
    }
}

