/*
 * Decompiled with CFR 0.152.
 */
package org.testifyproject.bouncycastle.crypto.generators;

import java.math.BigInteger;
import org.testifyproject.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.testifyproject.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import org.testifyproject.bouncycastle.crypto.KeyGenerationParameters;
import org.testifyproject.bouncycastle.crypto.params.RSAKeyGenerationParameters;
import org.testifyproject.bouncycastle.crypto.params.RSAKeyParameters;
import org.testifyproject.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;
import org.testifyproject.bouncycastle.math.ec.WNafUtil;

public class RSAKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    private RSAKeyGenerationParameters param;

    public void init(KeyGenerationParameters keyGenerationParameters) {
        this.param = (RSAKeyGenerationParameters)keyGenerationParameters;
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        BigInteger bigInteger;
        BigInteger bigInteger2;
        BigInteger bigInteger3;
        BigInteger bigInteger4;
        int n = this.param.getStrength();
        int n2 = n >>> 1;
        int n3 = n - n2;
        int n4 = n / 3;
        int n5 = n >>> 2;
        BigInteger bigInteger5 = this.param.getPublicExponent();
        BigInteger bigInteger6 = this.chooseRandomPrime(n3, bigInteger5);
        while (true) {
            if ((bigInteger4 = (bigInteger3 = this.chooseRandomPrime(n2, bigInteger5)).subtract(bigInteger6).abs()).bitLength() < n4) {
                continue;
            }
            bigInteger2 = bigInteger6.multiply(bigInteger3);
            if (bigInteger2.bitLength() != n) {
                bigInteger6 = bigInteger6.max(bigInteger3);
                continue;
            }
            if (WNafUtil.getNafWeight(bigInteger2) >= n5) break;
            bigInteger6 = this.chooseRandomPrime(n3, bigInteger5);
        }
        if (bigInteger6.compareTo(bigInteger3) < 0) {
            bigInteger = bigInteger6;
            bigInteger6 = bigInteger3;
            bigInteger3 = bigInteger;
        }
        BigInteger bigInteger7 = bigInteger6.subtract(ONE);
        BigInteger bigInteger8 = bigInteger3.subtract(ONE);
        bigInteger = bigInteger7.multiply(bigInteger8);
        BigInteger bigInteger9 = bigInteger5.modInverse(bigInteger);
        bigInteger4 = bigInteger9.remainder(bigInteger7);
        BigInteger bigInteger10 = bigInteger9.remainder(bigInteger8);
        BigInteger bigInteger11 = bigInteger3.modInverse(bigInteger6);
        return new AsymmetricCipherKeyPair(new RSAKeyParameters(false, bigInteger2, bigInteger5), new RSAPrivateCrtKeyParameters(bigInteger2, bigInteger5, bigInteger9, bigInteger6, bigInteger3, bigInteger4, bigInteger10, bigInteger11));
    }

    protected BigInteger chooseRandomPrime(int n, BigInteger bigInteger) {
        BigInteger bigInteger2;
        while ((bigInteger2 = new BigInteger(n, 1, this.param.getRandom())).mod(bigInteger).equals(ONE) || !bigInteger2.isProbablePrime(this.param.getCertainty()) || !bigInteger.gcd(bigInteger2.subtract(ONE)).equals(ONE)) {
        }
        return bigInteger2;
    }
}

