/*
 * Decompiled with CFR 0.152.
 */
package org.testifyproject.bouncycastle.crypto.modes.gcm;

import org.testifyproject.bouncycastle.util.Arrays;
import org.testifyproject.bouncycastle.util.Pack;

abstract class GCMUtil {
    private static final int E1 = -520093696;
    private static final byte E1B = -31;
    private static final long E1L = 0xE1000000000000L;
    private static final int[] LOOKUP = GCMUtil.generateLookup();

    GCMUtil() {
    }

    private static int[] generateLookup() {
        int[] nArray = new int[256];
        for (int i = 0; i < 256; ++i) {
            int n = 0;
            for (int j = 7; j >= 0; --j) {
                if ((i & 1 << j) == 0) continue;
                n ^= -520093696 >>> 7 - j;
            }
            nArray[i] = n;
        }
        return nArray;
    }

    static byte[] oneAsBytes() {
        byte[] byArray = new byte[16];
        byArray[0] = -128;
        return byArray;
    }

    static int[] oneAsInts() {
        int[] nArray = new int[4];
        nArray[0] = Integer.MIN_VALUE;
        return nArray;
    }

    static long[] oneAsLongs() {
        long[] lArray = new long[2];
        lArray[0] = Long.MIN_VALUE;
        return lArray;
    }

    static byte[] asBytes(int[] nArray) {
        byte[] byArray = new byte[16];
        Pack.intToBigEndian(nArray, byArray, 0);
        return byArray;
    }

    static void asBytes(int[] nArray, byte[] byArray) {
        Pack.intToBigEndian(nArray, byArray, 0);
    }

    static byte[] asBytes(long[] lArray) {
        byte[] byArray = new byte[16];
        Pack.longToBigEndian(lArray, byArray, 0);
        return byArray;
    }

    static void asBytes(long[] lArray, byte[] byArray) {
        Pack.longToBigEndian(lArray, byArray, 0);
    }

    static int[] asInts(byte[] byArray) {
        int[] nArray = new int[4];
        Pack.bigEndianToInt(byArray, 0, nArray);
        return nArray;
    }

    static void asInts(byte[] byArray, int[] nArray) {
        Pack.bigEndianToInt(byArray, 0, nArray);
    }

    static long[] asLongs(byte[] byArray) {
        long[] lArray = new long[2];
        Pack.bigEndianToLong(byArray, 0, lArray);
        return lArray;
    }

    static void asLongs(byte[] byArray, long[] lArray) {
        Pack.bigEndianToLong(byArray, 0, lArray);
    }

    static void multiply(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = Arrays.clone(byArray);
        byte[] byArray4 = new byte[16];
        for (int i = 0; i < 16; ++i) {
            byte by = byArray2[i];
            for (int j = 7; j >= 0; --j) {
                if ((by & 1 << j) != 0) {
                    GCMUtil.xor(byArray4, byArray3);
                }
                if (GCMUtil.shiftRight(byArray3) == 0) continue;
                byArray3[0] = (byte)(byArray3[0] ^ 0xFFFFFFE1);
            }
        }
        System.arraycopy(byArray4, 0, byArray, 0, 16);
    }

    static void multiply(int[] nArray, int[] nArray2) {
        int[] nArray3 = Arrays.clone(nArray);
        int[] nArray4 = new int[4];
        for (int i = 0; i < 4; ++i) {
            int n = nArray2[i];
            for (int j = 31; j >= 0; --j) {
                if ((n & 1 << j) != 0) {
                    GCMUtil.xor(nArray4, nArray3);
                }
                if (GCMUtil.shiftRight(nArray3) == 0) continue;
                nArray3[0] = nArray3[0] ^ 0xE1000000;
            }
        }
        System.arraycopy(nArray4, 0, nArray, 0, 4);
    }

    static void multiply(long[] lArray, long[] lArray2) {
        long[] lArray3 = new long[]{lArray[0], lArray[1]};
        long[] lArray4 = new long[2];
        for (int i = 0; i < 2; ++i) {
            long l = lArray2[i];
            for (int j = 63; j >= 0; --j) {
                if ((l & 1L << j) != 0L) {
                    GCMUtil.xor(lArray4, lArray3);
                }
                if (GCMUtil.shiftRight(lArray3) == 0L) continue;
                lArray3[0] = lArray3[0] ^ 0xE1000000000000L;
            }
        }
        lArray[0] = lArray4[0];
        lArray[1] = lArray4[1];
    }

    static void multiplyP(int[] nArray) {
        if (GCMUtil.shiftRight(nArray) != 0) {
            nArray[0] = nArray[0] ^ 0xE1000000;
        }
    }

    static void multiplyP(int[] nArray, int[] nArray2) {
        if (GCMUtil.shiftRight(nArray, nArray2) != 0) {
            nArray2[0] = nArray2[0] ^ 0xE1000000;
        }
    }

    static void multiplyP8(int[] nArray) {
        int n = GCMUtil.shiftRightN(nArray, 8);
        nArray[0] = nArray[0] ^ LOOKUP[n >>> 24];
    }

    static void multiplyP8(int[] nArray, int[] nArray2) {
        int n = GCMUtil.shiftRightN(nArray, 8, nArray2);
        nArray2[0] = nArray2[0] ^ LOOKUP[n >>> 24];
    }

    static byte shiftRight(byte[] byArray) {
        int n = 0;
        int n2 = 0;
        do {
            int n3 = byArray[n] & 0xFF;
            byArray[n++] = (byte)(n3 >>> 1 | n2);
            n2 = (n3 & 1) << 7;
            n3 = byArray[n] & 0xFF;
            byArray[n++] = (byte)(n3 >>> 1 | n2);
            n2 = (n3 & 1) << 7;
            n3 = byArray[n] & 0xFF;
            byArray[n++] = (byte)(n3 >>> 1 | n2);
            n2 = (n3 & 1) << 7;
            n3 = byArray[n] & 0xFF;
            byArray[n++] = (byte)(n3 >>> 1 | n2);
            n2 = (n3 & 1) << 7;
        } while (n < 16);
        return (byte)n2;
    }

    static byte shiftRight(byte[] byArray, byte[] byArray2) {
        int n = 0;
        int n2 = 0;
        do {
            int n3 = byArray[n] & 0xFF;
            byArray2[n++] = (byte)(n3 >>> 1 | n2);
            n2 = (n3 & 1) << 7;
            n3 = byArray[n] & 0xFF;
            byArray2[n++] = (byte)(n3 >>> 1 | n2);
            n2 = (n3 & 1) << 7;
            n3 = byArray[n] & 0xFF;
            byArray2[n++] = (byte)(n3 >>> 1 | n2);
            n2 = (n3 & 1) << 7;
            n3 = byArray[n] & 0xFF;
            byArray2[n++] = (byte)(n3 >>> 1 | n2);
            n2 = (n3 & 1) << 7;
        } while (n < 16);
        return (byte)n2;
    }

    static int shiftRight(int[] nArray) {
        int n = nArray[0];
        nArray[0] = n >>> 1;
        int n2 = n << 31;
        n = nArray[1];
        nArray[1] = n >>> 1 | n2;
        n2 = n << 31;
        n = nArray[2];
        nArray[2] = n >>> 1 | n2;
        n2 = n << 31;
        n = nArray[3];
        nArray[3] = n >>> 1 | n2;
        return n << 31;
    }

    static int shiftRight(int[] nArray, int[] nArray2) {
        int n = nArray[0];
        nArray2[0] = n >>> 1;
        int n2 = n << 31;
        n = nArray[1];
        nArray2[1] = n >>> 1 | n2;
        n2 = n << 31;
        n = nArray[2];
        nArray2[2] = n >>> 1 | n2;
        n2 = n << 31;
        n = nArray[3];
        nArray2[3] = n >>> 1 | n2;
        return n << 31;
    }

    static long shiftRight(long[] lArray) {
        long l = lArray[0];
        lArray[0] = l >>> 1;
        long l2 = l << 63;
        l = lArray[1];
        lArray[1] = l >>> 1 | l2;
        return l << 63;
    }

    static long shiftRight(long[] lArray, long[] lArray2) {
        long l = lArray[0];
        lArray2[0] = l >>> 1;
        long l2 = l << 63;
        l = lArray[1];
        lArray2[1] = l >>> 1 | l2;
        return l << 63;
    }

    static int shiftRightN(int[] nArray, int n) {
        int n2 = nArray[0];
        int n3 = 32 - n;
        nArray[0] = n2 >>> n;
        int n4 = n2 << n3;
        n2 = nArray[1];
        nArray[1] = n2 >>> n | n4;
        n4 = n2 << n3;
        n2 = nArray[2];
        nArray[2] = n2 >>> n | n4;
        n4 = n2 << n3;
        n2 = nArray[3];
        nArray[3] = n2 >>> n | n4;
        return n2 << n3;
    }

    static int shiftRightN(int[] nArray, int n, int[] nArray2) {
        int n2 = nArray[0];
        int n3 = 32 - n;
        nArray2[0] = n2 >>> n;
        int n4 = n2 << n3;
        n2 = nArray[1];
        nArray2[1] = n2 >>> n | n4;
        n4 = n2 << n3;
        n2 = nArray[2];
        nArray2[2] = n2 >>> n | n4;
        n4 = n2 << n3;
        n2 = nArray[3];
        nArray2[3] = n2 >>> n | n4;
        return n2 << n3;
    }

    static void xor(byte[] byArray, byte[] byArray2) {
        int n = 0;
        do {
            int n2 = n;
            byArray[n2] = (byte)(byArray[n2] ^ byArray2[n]);
            int n3 = ++n;
            byArray[n3] = (byte)(byArray[n3] ^ byArray2[n]);
            int n4 = ++n;
            byArray[n4] = (byte)(byArray[n4] ^ byArray2[n]);
            int n5 = ++n;
            byArray[n5] = (byte)(byArray[n5] ^ byArray2[n]);
        } while (++n < 16);
    }

    static void xor(byte[] byArray, byte[] byArray2, int n, int n2) {
        while (n2-- > 0) {
            int n3 = n2;
            byArray[n3] = (byte)(byArray[n3] ^ byArray2[n + n2]);
        }
    }

    static void xor(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        int n = 0;
        do {
            byArray3[n] = (byte)(byArray[n] ^ byArray2[n]);
            byArray3[++n] = (byte)(byArray[n] ^ byArray2[n]);
            byArray3[++n] = (byte)(byArray[n] ^ byArray2[n]);
            byArray3[++n] = (byte)(byArray[n] ^ byArray2[n]);
        } while (++n < 16);
    }

    static void xor(int[] nArray, int[] nArray2) {
        nArray[0] = nArray[0] ^ nArray2[0];
        nArray[1] = nArray[1] ^ nArray2[1];
        nArray[2] = nArray[2] ^ nArray2[2];
        nArray[3] = nArray[3] ^ nArray2[3];
    }

    static void xor(int[] nArray, int[] nArray2, int[] nArray3) {
        nArray3[0] = nArray[0] ^ nArray2[0];
        nArray3[1] = nArray[1] ^ nArray2[1];
        nArray3[2] = nArray[2] ^ nArray2[2];
        nArray3[3] = nArray[3] ^ nArray2[3];
    }

    static void xor(long[] lArray, long[] lArray2) {
        lArray[0] = lArray[0] ^ lArray2[0];
        lArray[1] = lArray[1] ^ lArray2[1];
    }

    static void xor(long[] lArray, long[] lArray2, long[] lArray3) {
        lArray3[0] = lArray[0] ^ lArray2[0];
        lArray3[1] = lArray[1] ^ lArray2[1];
    }
}

