/*
 * Decompiled with CFR 0.152.
 */
package org.testifyproject.bouncycastle.crypto.tls;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.SecureRandom;
import org.testifyproject.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.testifyproject.bouncycastle.crypto.agreement.DHBasicAgreement;
import org.testifyproject.bouncycastle.crypto.generators.DHBasicKeyPairGenerator;
import org.testifyproject.bouncycastle.crypto.params.DHKeyGenerationParameters;
import org.testifyproject.bouncycastle.crypto.params.DHParameters;
import org.testifyproject.bouncycastle.crypto.params.DHPrivateKeyParameters;
import org.testifyproject.bouncycastle.crypto.params.DHPublicKeyParameters;
import org.testifyproject.bouncycastle.crypto.tls.ServerDHParams;
import org.testifyproject.bouncycastle.crypto.tls.TlsFatalAlert;
import org.testifyproject.bouncycastle.crypto.tls.TlsUtils;
import org.testifyproject.bouncycastle.util.BigIntegers;

public class TlsDHUtils {
    static final BigInteger ONE = BigInteger.valueOf(1L);
    static final BigInteger TWO = BigInteger.valueOf(2L);

    public static boolean areCompatibleParameters(DHParameters dHParameters, DHParameters dHParameters2) {
        return dHParameters.getP().equals(dHParameters2.getP()) && dHParameters.getG().equals(dHParameters2.getG());
    }

    public static byte[] calculateDHBasicAgreement(DHPublicKeyParameters dHPublicKeyParameters, DHPrivateKeyParameters dHPrivateKeyParameters) {
        DHBasicAgreement dHBasicAgreement = new DHBasicAgreement();
        dHBasicAgreement.init(dHPrivateKeyParameters);
        BigInteger bigInteger = dHBasicAgreement.calculateAgreement(dHPublicKeyParameters);
        return BigIntegers.asUnsignedByteArray(bigInteger);
    }

    public static AsymmetricCipherKeyPair generateDHKeyPair(SecureRandom secureRandom, DHParameters dHParameters) {
        DHBasicKeyPairGenerator dHBasicKeyPairGenerator = new DHBasicKeyPairGenerator();
        dHBasicKeyPairGenerator.init(new DHKeyGenerationParameters(secureRandom, dHParameters));
        return dHBasicKeyPairGenerator.generateKeyPair();
    }

    public static DHPrivateKeyParameters generateEphemeralClientKeyExchange(SecureRandom secureRandom, DHParameters dHParameters, OutputStream outputStream) throws IOException {
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = TlsDHUtils.generateDHKeyPair(secureRandom, dHParameters);
        DHPublicKeyParameters dHPublicKeyParameters = (DHPublicKeyParameters)asymmetricCipherKeyPair.getPublic();
        TlsDHUtils.writeDHParameter(dHPublicKeyParameters.getY(), outputStream);
        return (DHPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate();
    }

    public static DHPrivateKeyParameters generateEphemeralServerKeyExchange(SecureRandom secureRandom, DHParameters dHParameters, OutputStream outputStream) throws IOException {
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = TlsDHUtils.generateDHKeyPair(secureRandom, dHParameters);
        DHPublicKeyParameters dHPublicKeyParameters = (DHPublicKeyParameters)asymmetricCipherKeyPair.getPublic();
        ServerDHParams serverDHParams = new ServerDHParams(dHPublicKeyParameters);
        serverDHParams.encode(outputStream);
        return (DHPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate();
    }

    public static DHPublicKeyParameters validateDHPublicKey(DHPublicKeyParameters dHPublicKeyParameters) throws IOException {
        BigInteger bigInteger = dHPublicKeyParameters.getY();
        DHParameters dHParameters = dHPublicKeyParameters.getParameters();
        BigInteger bigInteger2 = dHParameters.getP();
        BigInteger bigInteger3 = dHParameters.getG();
        if (!bigInteger2.isProbablePrime(2)) {
            throw new TlsFatalAlert(47);
        }
        if (bigInteger3.compareTo(TWO) < 0 || bigInteger3.compareTo(bigInteger2.subtract(TWO)) > 0) {
            throw new TlsFatalAlert(47);
        }
        if (bigInteger.compareTo(TWO) < 0 || bigInteger.compareTo(bigInteger2.subtract(ONE)) > 0) {
            throw new TlsFatalAlert(47);
        }
        return dHPublicKeyParameters;
    }

    public static BigInteger readDHParameter(InputStream inputStream) throws IOException {
        return new BigInteger(1, TlsUtils.readOpaque16(inputStream));
    }

    public static void writeDHParameter(BigInteger bigInteger, OutputStream outputStream) throws IOException {
        TlsUtils.writeOpaque16(BigIntegers.asUnsignedByteArray(bigInteger), outputStream);
    }
}

