/*
 * Decompiled with CFR 0.152.
 */
package org.testifyproject.bouncycastle.crypto.tls;

import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import org.testifyproject.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.testifyproject.bouncycastle.crypto.Digest;
import org.testifyproject.bouncycastle.crypto.Signer;
import org.testifyproject.bouncycastle.crypto.params.ECDomainParameters;
import org.testifyproject.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.testifyproject.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.testifyproject.bouncycastle.crypto.tls.CertificateRequest;
import org.testifyproject.bouncycastle.crypto.tls.CombinedHash;
import org.testifyproject.bouncycastle.crypto.tls.DigestInputBuffer;
import org.testifyproject.bouncycastle.crypto.tls.DigitallySigned;
import org.testifyproject.bouncycastle.crypto.tls.NamedCurve;
import org.testifyproject.bouncycastle.crypto.tls.SecurityParameters;
import org.testifyproject.bouncycastle.crypto.tls.SignatureAndHashAlgorithm;
import org.testifyproject.bouncycastle.crypto.tls.SignerInputBuffer;
import org.testifyproject.bouncycastle.crypto.tls.TlsCredentials;
import org.testifyproject.bouncycastle.crypto.tls.TlsECCUtils;
import org.testifyproject.bouncycastle.crypto.tls.TlsECDHKeyExchange;
import org.testifyproject.bouncycastle.crypto.tls.TlsFatalAlert;
import org.testifyproject.bouncycastle.crypto.tls.TlsSigner;
import org.testifyproject.bouncycastle.crypto.tls.TlsSignerCredentials;
import org.testifyproject.bouncycastle.crypto.tls.TlsUtils;
import org.testifyproject.bouncycastle.util.Arrays;
import org.testifyproject.bouncycastle.util.io.TeeInputStream;

public class TlsECDHEKeyExchange
extends TlsECDHKeyExchange {
    protected TlsSignerCredentials serverCredentials = null;

    public TlsECDHEKeyExchange(int n, Vector vector, int[] nArray, short[] sArray, short[] sArray2) {
        super(n, vector, nArray, sArray, sArray2);
    }

    public void processServerCredentials(TlsCredentials tlsCredentials) throws IOException {
        if (!(tlsCredentials instanceof TlsSignerCredentials)) {
            throw new TlsFatalAlert(80);
        }
        this.processServerCertificate(tlsCredentials.getCertificate());
        this.serverCredentials = (TlsSignerCredentials)tlsCredentials;
    }

    public byte[] generateServerKeyExchange() throws IOException {
        Digest digest;
        SignatureAndHashAlgorithm signatureAndHashAlgorithm;
        int n = -1;
        if (this.namedCurves == null) {
            n = 23;
        } else {
            for (int i = 0; i < this.namedCurves.length; ++i) {
                int n2 = this.namedCurves[i];
                if (!NamedCurve.isValid(n2) || !TlsECCUtils.isSupportedNamedCurve(n2)) continue;
                n = n2;
                break;
            }
        }
        ECDomainParameters eCDomainParameters = null;
        if (n >= 0) {
            eCDomainParameters = TlsECCUtils.getParametersForNamedCurve(n);
        } else if (Arrays.contains(this.namedCurves, 65281)) {
            eCDomainParameters = TlsECCUtils.getParametersForNamedCurve(23);
        } else if (Arrays.contains(this.namedCurves, 65282)) {
            eCDomainParameters = TlsECCUtils.getParametersForNamedCurve(10);
        }
        if (eCDomainParameters == null) {
            throw new TlsFatalAlert(80);
        }
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = TlsECCUtils.generateECKeyPair(this.context.getSecureRandom(), eCDomainParameters);
        this.ecAgreePrivateKey = (ECPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate();
        DigestInputBuffer digestInputBuffer = new DigestInputBuffer();
        if (n < 0) {
            TlsECCUtils.writeExplicitECParameters(this.clientECPointFormats, eCDomainParameters, digestInputBuffer);
        } else {
            TlsECCUtils.writeNamedECParameters(n, digestInputBuffer);
        }
        ECPublicKeyParameters eCPublicKeyParameters = (ECPublicKeyParameters)asymmetricCipherKeyPair.getPublic();
        TlsECCUtils.writeECPoint(this.clientECPointFormats, eCPublicKeyParameters.getQ(), digestInputBuffer);
        if (TlsUtils.isTLSv12(this.context)) {
            signatureAndHashAlgorithm = this.serverCredentials.getSignatureAndHashAlgorithm();
            if (signatureAndHashAlgorithm == null) {
                throw new TlsFatalAlert(80);
            }
            digest = TlsUtils.createHash(signatureAndHashAlgorithm.getHash());
        } else {
            signatureAndHashAlgorithm = null;
            digest = new CombinedHash();
        }
        SecurityParameters securityParameters = this.context.getSecurityParameters();
        digest.update(securityParameters.clientRandom, 0, securityParameters.clientRandom.length);
        digest.update(securityParameters.serverRandom, 0, securityParameters.serverRandom.length);
        digestInputBuffer.updateDigest(digest);
        byte[] byArray = new byte[digest.getDigestSize()];
        digest.doFinal(byArray, 0);
        byte[] byArray2 = this.serverCredentials.generateCertificateSignature(byArray);
        DigitallySigned digitallySigned = new DigitallySigned(signatureAndHashAlgorithm, byArray2);
        digitallySigned.encode(digestInputBuffer);
        return digestInputBuffer.toByteArray();
    }

    public void processServerKeyExchange(InputStream inputStream) throws IOException {
        SecurityParameters securityParameters = this.context.getSecurityParameters();
        SignerInputBuffer signerInputBuffer = new SignerInputBuffer();
        TeeInputStream teeInputStream = new TeeInputStream(inputStream, signerInputBuffer);
        ECDomainParameters eCDomainParameters = TlsECCUtils.readECParameters(this.namedCurves, this.clientECPointFormats, teeInputStream);
        byte[] byArray = TlsUtils.readOpaque8(teeInputStream);
        DigitallySigned digitallySigned = DigitallySigned.parse(this.context, inputStream);
        Signer signer = this.initVerifyer(this.tlsSigner, digitallySigned.getAlgorithm(), securityParameters);
        signerInputBuffer.updateSigner(signer);
        if (!signer.verifySignature(digitallySigned.getSignature())) {
            throw new TlsFatalAlert(51);
        }
        this.ecAgreePublicKey = TlsECCUtils.validateECPublicKey(TlsECCUtils.deserializeECPublicKey(this.clientECPointFormats, eCDomainParameters, byArray));
    }

    public void validateCertificateRequest(CertificateRequest certificateRequest) throws IOException {
        short[] sArray = certificateRequest.getCertificateTypes();
        block3: for (int i = 0; i < sArray.length; ++i) {
            switch (sArray[i]) {
                case 1: 
                case 2: 
                case 64: {
                    continue block3;
                }
                default: {
                    throw new TlsFatalAlert(47);
                }
            }
        }
    }

    public void processClientCredentials(TlsCredentials tlsCredentials) throws IOException {
        if (!(tlsCredentials instanceof TlsSignerCredentials)) {
            throw new TlsFatalAlert(80);
        }
    }

    protected Signer initVerifyer(TlsSigner tlsSigner, SignatureAndHashAlgorithm signatureAndHashAlgorithm, SecurityParameters securityParameters) {
        Signer signer = tlsSigner.createVerifyer(signatureAndHashAlgorithm, this.serverPublicKey);
        signer.update(securityParameters.clientRandom, 0, securityParameters.clientRandom.length);
        signer.update(securityParameters.serverRandom, 0, securityParameters.serverRandom.length);
        return signer;
    }
}

