/*
 * Decompiled with CFR 0.152.
 */
package org.testifyproject.bouncycastle.crypto.tls;

import org.testifyproject.bouncycastle.crypto.DSA;
import org.testifyproject.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.testifyproject.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.testifyproject.bouncycastle.crypto.signers.ECDSASigner;
import org.testifyproject.bouncycastle.crypto.signers.HMacDSAKCalculator;
import org.testifyproject.bouncycastle.crypto.tls.TlsDSASigner;
import org.testifyproject.bouncycastle.crypto.tls.TlsUtils;

public class TlsECDSASigner
extends TlsDSASigner {
    public boolean isValidPublicKey(AsymmetricKeyParameter asymmetricKeyParameter) {
        return asymmetricKeyParameter instanceof ECPublicKeyParameters;
    }

    protected DSA createDSAImpl(short s) {
        return new ECDSASigner(new HMacDSAKCalculator(TlsUtils.createHash(s)));
    }

    protected short getSignatureAlgorithm() {
        return 3;
    }
}

