/*
 * Decompiled with CFR 0.152.
 */
package org.testifyproject.bouncycastle.dvcs;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.testifyproject.bouncycastle.asn1.dvcs.CertEtcToken;
import org.testifyproject.bouncycastle.asn1.dvcs.DVCSRequestInformationBuilder;
import org.testifyproject.bouncycastle.asn1.dvcs.DVCSTime;
import org.testifyproject.bouncycastle.asn1.dvcs.Data;
import org.testifyproject.bouncycastle.asn1.dvcs.ServiceType;
import org.testifyproject.bouncycastle.asn1.dvcs.TargetEtcChain;
import org.testifyproject.bouncycastle.asn1.x509.Extension;
import org.testifyproject.bouncycastle.cert.X509CertificateHolder;
import org.testifyproject.bouncycastle.dvcs.DVCSException;
import org.testifyproject.bouncycastle.dvcs.DVCSRequest;
import org.testifyproject.bouncycastle.dvcs.DVCSRequestBuilder;
import org.testifyproject.bouncycastle.dvcs.TargetChain;

public class VPKCRequestBuilder
extends DVCSRequestBuilder {
    private List chains = new ArrayList();

    public VPKCRequestBuilder() {
        super(new DVCSRequestInformationBuilder(ServiceType.VPKC));
    }

    public void addTargetChain(X509CertificateHolder x509CertificateHolder) {
        this.chains.add(new TargetEtcChain(new CertEtcToken(0, x509CertificateHolder.toASN1Structure())));
    }

    public void addTargetChain(Extension extension) {
        this.chains.add(new TargetEtcChain(new CertEtcToken(extension)));
    }

    public void addTargetChain(TargetChain targetChain) {
        this.chains.add(targetChain.toASN1Structure());
    }

    public void setRequestTime(Date date) {
        this.requestInformationBuilder.setRequestTime(new DVCSTime(date));
    }

    public DVCSRequest build() throws DVCSException {
        Data data = new Data(this.chains.toArray(new TargetEtcChain[this.chains.size()]));
        return this.createDVCRequest(data);
    }
}

