/*
 * Decompiled with CFR 0.152.
 */
package org.testifyproject.bouncycastle.math.ec.tools;

import java.io.Serializable;
import java.math.BigInteger;
import java.security.SecureRandom;
import org.testifyproject.bouncycastle.asn1.x9.ECNamedCurveTable;
import org.testifyproject.bouncycastle.asn1.x9.X9ECParameters;
import org.testifyproject.bouncycastle.math.ec.ECAlgorithms;
import org.testifyproject.bouncycastle.math.ec.ECConstants;
import org.testifyproject.bouncycastle.math.ec.ECCurve;
import org.testifyproject.bouncycastle.math.ec.ECFieldElement;
import org.testifyproject.bouncycastle.math.ec.ECPoint;
import org.testifyproject.bouncycastle.util.BigIntegers;

public class DiscoverEndomorphisms {
    private static final int radix = 16;

    public static void main(String[] stringArray) {
        if (stringArray.length < 1) {
            System.err.println("Expected a list of curve names as arguments");
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            DiscoverEndomorphisms.discoverEndomorphism(stringArray[i]);
        }
    }

    private static void discoverEndomorphism(String string) {
        X9ECParameters x9ECParameters = ECNamedCurveTable.getByName(string);
        if (x9ECParameters == null) {
            System.err.println("Unknown curve: " + string);
            return;
        }
        ECCurve eCCurve = x9ECParameters.getCurve();
        if (ECAlgorithms.isFpCurve(eCCurve)) {
            BigInteger bigInteger = eCCurve.getField().getCharacteristic();
            if (eCCurve.getA().isZero() && bigInteger.mod(ECConstants.THREE).equals(ECConstants.ONE)) {
                System.out.println("Curve '" + string + "' has a 'GLV Type B' endomorphism with these parameters: ");
                DiscoverEndomorphisms.printGLVTypeBParameters(x9ECParameters);
            }
        }
    }

    private static void printGLVTypeBParameters(X9ECParameters x9ECParameters) {
        BigInteger bigInteger;
        BigInteger bigInteger2;
        Serializable serializable;
        BigInteger bigInteger3;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        BigInteger bigInteger4 = x9ECParameters.getN();
        BigInteger[] bigIntegerArray = null;
        BigInteger[] bigIntegerArray2 = null;
        BigInteger bigInteger5 = DiscoverEndomorphisms.solveQuadraticEquation(bigInteger4, ECConstants.ONE, ECConstants.ONE);
        BigInteger[] bigIntegerArray3 = DiscoverEndomorphisms.extEuclidGLV(bigInteger4, bigInteger5);
        bigIntegerArray = new BigInteger[]{bigIntegerArray3[2], bigIntegerArray3[3].negate()};
        bigIntegerArray2 = DiscoverEndomorphisms.chooseShortest(new BigInteger[]{bigIntegerArray3[0], bigIntegerArray3[1].negate()}, new BigInteger[]{bigIntegerArray3[4], bigIntegerArray3[5].negate()});
        if (!DiscoverEndomorphisms.isVectorBoundedBySqrt(bigIntegerArray2, bigInteger4) && DiscoverEndomorphisms.areRelativelyPrime(bigIntegerArray[0], bigIntegerArray[1])) {
            BigInteger[] bigIntegerArray4;
            object4 = bigIntegerArray[0];
            object3 = bigIntegerArray[1];
            object2 = ((BigInteger)object4).add(((BigInteger)object3).multiply(bigInteger5)).divide(bigInteger4);
            object = DiscoverEndomorphisms.extEuclidBezout(new BigInteger[]{((BigInteger)object2).abs(), ((BigInteger)object3).abs()});
            bigInteger3 = object[0];
            serializable = object[1];
            if (((BigInteger)object2).signum() < 0) {
                bigInteger3 = bigInteger3.negate();
            }
            if (((BigInteger)object3).signum() > 0) {
                serializable = ((BigInteger)serializable).negate();
            }
            if (!(bigInteger2 = ((BigInteger)object2).multiply(bigInteger3).subtract(((BigInteger)object3).multiply((BigInteger)serializable))).equals(ECConstants.ONE)) {
                throw new IllegalStateException();
            }
            bigInteger = ((BigInteger)serializable).multiply(bigInteger4).subtract(bigInteger3.multiply(bigInteger5));
            BigInteger bigInteger6 = bigInteger3.negate();
            BigInteger bigInteger7 = bigInteger.negate();
            BigInteger bigInteger8 = DiscoverEndomorphisms.isqrt(bigInteger4.subtract(ECConstants.ONE)).add(ECConstants.ONE);
            BigInteger[] bigIntegerArray5 = DiscoverEndomorphisms.calculateRange(bigInteger6, bigInteger8, (BigInteger)object3);
            BigInteger[] bigIntegerArray6 = DiscoverEndomorphisms.intersect(bigIntegerArray5, bigIntegerArray4 = DiscoverEndomorphisms.calculateRange(bigInteger7, bigInteger8, (BigInteger)object4));
            if (bigIntegerArray6 != null) {
                BigInteger bigInteger9 = bigIntegerArray6[0];
                while (bigInteger9.compareTo(bigIntegerArray6[1]) <= 0) {
                    BigInteger[] bigIntegerArray7 = new BigInteger[]{bigInteger.add(bigInteger9.multiply((BigInteger)object4)), bigInteger3.add(bigInteger9.multiply((BigInteger)object3))};
                    if (DiscoverEndomorphisms.isShorter(bigIntegerArray7, bigIntegerArray2)) {
                        bigIntegerArray2 = bigIntegerArray7;
                    }
                    bigInteger9 = bigInteger9.add(ECConstants.ONE);
                }
            }
        }
        object3 = x9ECParameters.getG().normalize();
        object2 = ((ECPoint)object3).multiply(bigInteger5).normalize();
        if (!((ECPoint)object3).getYCoord().equals(((ECPoint)object2).getYCoord())) {
            throw new IllegalStateException("Derivation of GLV Type B parameters failed unexpectedly");
        }
        object = x9ECParameters.getCurve().getField().getCharacteristic();
        bigInteger3 = ((BigInteger)object).divide(ECConstants.THREE);
        serializable = new SecureRandom();
        while ((bigInteger2 = (bigInteger = BigIntegers.createRandomInRange(ECConstants.TWO, ((BigInteger)object).subtract(ECConstants.TWO), (SecureRandom)serializable)).modPow(bigInteger3, (BigInteger)object)).equals(ECConstants.ONE)) {
        }
        object4 = x9ECParameters.getCurve().fromBigInteger(ECConstants.TWO.modPow(bigInteger3, (BigInteger)object));
        if (!((ECPoint)object3).getXCoord().multiply((ECFieldElement)object4).equals(((ECPoint)object2).getXCoord())) {
            object4 = ((ECFieldElement)object4).square();
            if (!((ECPoint)object3).getXCoord().multiply((ECFieldElement)object4).equals(((ECPoint)object2).getXCoord())) {
                throw new IllegalStateException("Derivation of GLV Type B parameters failed unexpectedly");
            }
        }
        object3 = bigIntegerArray[0].multiply(bigIntegerArray2[1]).subtract(bigIntegerArray[1].multiply(bigIntegerArray2[0]));
        int n = bigInteger4.bitLength() + 16 - (bigInteger4.bitLength() & 7);
        object = DiscoverEndomorphisms.roundQuotient(bigIntegerArray2[1].shiftLeft(n), (BigInteger)object3);
        bigInteger3 = DiscoverEndomorphisms.roundQuotient(bigIntegerArray[1].shiftLeft(n), (BigInteger)object3).negate();
        DiscoverEndomorphisms.printProperty("Beta", ((ECFieldElement)object4).toBigInteger().toString(16));
        DiscoverEndomorphisms.printProperty("Lambda", bigInteger5.toString(16));
        DiscoverEndomorphisms.printProperty("v1", "{ " + bigIntegerArray[0].toString(16) + ", " + bigIntegerArray[1].toString(16) + " }");
        DiscoverEndomorphisms.printProperty("v2", "{ " + bigIntegerArray2[0].toString(16) + ", " + bigIntegerArray2[1].toString(16) + " }");
        DiscoverEndomorphisms.printProperty("(OPT) g1", ((BigInteger)object).toString(16));
        DiscoverEndomorphisms.printProperty("(OPT) g2", bigInteger3.toString(16));
        DiscoverEndomorphisms.printProperty("(OPT) bits", Integer.toString(n));
    }

    private static void printProperty(String string, Object object) {
        StringBuffer stringBuffer = new StringBuffer("  ");
        stringBuffer.append(string);
        while (stringBuffer.length() < 20) {
            stringBuffer.append(' ');
        }
        stringBuffer.append("= ");
        stringBuffer.append(object.toString());
        System.out.println(stringBuffer.toString());
    }

    private static boolean areRelativelyPrime(BigInteger bigInteger, BigInteger bigInteger2) {
        return bigInteger.gcd(bigInteger2).equals(ECConstants.ONE);
    }

    private static BigInteger[] calculateRange(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
        BigInteger bigInteger4 = bigInteger.subtract(bigInteger2).divide(bigInteger3);
        BigInteger bigInteger5 = bigInteger.add(bigInteger2).divide(bigInteger3);
        return DiscoverEndomorphisms.order(bigInteger4, bigInteger5);
    }

    private static BigInteger[] extEuclidBezout(BigInteger[] bigIntegerArray) {
        BigInteger[] bigIntegerArray2;
        boolean bl;
        boolean bl2 = bl = bigIntegerArray[0].compareTo(bigIntegerArray[1]) < 0;
        if (bl) {
            DiscoverEndomorphisms.swap(bigIntegerArray);
        }
        BigInteger bigInteger = bigIntegerArray[0];
        BigInteger bigInteger2 = bigIntegerArray[1];
        BigInteger bigInteger3 = ECConstants.ONE;
        BigInteger bigInteger4 = ECConstants.ZERO;
        BigInteger bigInteger5 = ECConstants.ZERO;
        BigInteger bigInteger6 = ECConstants.ONE;
        while (bigInteger2.compareTo(ECConstants.ONE) > 0) {
            bigIntegerArray2 = bigInteger.divideAndRemainder(bigInteger2);
            BigInteger bigInteger7 = bigIntegerArray2[0];
            BigInteger bigInteger8 = bigIntegerArray2[1];
            BigInteger bigInteger9 = bigInteger3.subtract(bigInteger7.multiply(bigInteger4));
            BigInteger bigInteger10 = bigInteger5.subtract(bigInteger7.multiply(bigInteger6));
            bigInteger = bigInteger2;
            bigInteger2 = bigInteger8;
            bigInteger3 = bigInteger4;
            bigInteger4 = bigInteger9;
            bigInteger5 = bigInteger6;
            bigInteger6 = bigInteger10;
        }
        if (bigInteger2.signum() <= 0) {
            throw new IllegalStateException();
        }
        bigIntegerArray2 = new BigInteger[]{bigInteger4, bigInteger6};
        if (bl) {
            DiscoverEndomorphisms.swap(bigIntegerArray2);
        }
        return bigIntegerArray2;
    }

    private static BigInteger[] extEuclidGLV(BigInteger bigInteger, BigInteger bigInteger2) {
        BigInteger bigInteger3 = bigInteger;
        BigInteger bigInteger4 = bigInteger2;
        BigInteger bigInteger5 = ECConstants.ZERO;
        BigInteger bigInteger6 = ECConstants.ONE;
        while (true) {
            BigInteger[] bigIntegerArray = bigInteger3.divideAndRemainder(bigInteger4);
            BigInteger bigInteger7 = bigIntegerArray[0];
            BigInteger bigInteger8 = bigIntegerArray[1];
            BigInteger bigInteger9 = bigInteger5.subtract(bigInteger7.multiply(bigInteger6));
            if (DiscoverEndomorphisms.isLessThanSqrt(bigInteger4, bigInteger)) {
                return new BigInteger[]{bigInteger3, bigInteger5, bigInteger4, bigInteger6, bigInteger8, bigInteger9};
            }
            bigInteger3 = bigInteger4;
            bigInteger4 = bigInteger8;
            bigInteger5 = bigInteger6;
            bigInteger6 = bigInteger9;
        }
    }

    private static BigInteger[] chooseShortest(BigInteger[] bigIntegerArray, BigInteger[] bigIntegerArray2) {
        return DiscoverEndomorphisms.isShorter(bigIntegerArray, bigIntegerArray2) ? bigIntegerArray : bigIntegerArray2;
    }

    private static BigInteger[] intersect(BigInteger[] bigIntegerArray, BigInteger[] bigIntegerArray2) {
        BigInteger bigInteger;
        BigInteger bigInteger2 = bigIntegerArray[0].max(bigIntegerArray2[0]);
        if (bigInteger2.compareTo(bigInteger = bigIntegerArray[1].min(bigIntegerArray2[1])) > 0) {
            return null;
        }
        return new BigInteger[]{bigInteger2, bigInteger};
    }

    private static boolean isLessThanSqrt(BigInteger bigInteger, BigInteger bigInteger2) {
        bigInteger = bigInteger.abs();
        bigInteger2 = bigInteger2.abs();
        int n = bigInteger2.bitLength();
        int n2 = bigInteger.bitLength() * 2;
        int n3 = n2 - 1;
        return n3 <= n && (n2 < n || bigInteger.multiply(bigInteger).compareTo(bigInteger2) < 0);
    }

    private static boolean isShorter(BigInteger[] bigIntegerArray, BigInteger[] bigIntegerArray2) {
        BigInteger bigInteger;
        boolean bl;
        BigInteger bigInteger2 = bigIntegerArray[0].abs();
        BigInteger bigInteger3 = bigIntegerArray[1].abs();
        BigInteger bigInteger4 = bigIntegerArray2[0].abs();
        BigInteger bigInteger5 = bigIntegerArray2[1].abs();
        boolean bl2 = bigInteger2.compareTo(bigInteger4) < 0;
        boolean bl3 = bl = bigInteger3.compareTo(bigInteger5) < 0;
        if (bl2 == bl) {
            return bl2;
        }
        BigInteger bigInteger6 = bigInteger2.multiply(bigInteger2).add(bigInteger3.multiply(bigInteger3));
        return bigInteger6.compareTo(bigInteger = bigInteger4.multiply(bigInteger4).add(bigInteger5.multiply(bigInteger5))) < 0;
    }

    private static boolean isVectorBoundedBySqrt(BigInteger[] bigIntegerArray, BigInteger bigInteger) {
        BigInteger bigInteger2 = bigIntegerArray[0].abs().max(bigIntegerArray[1].abs());
        return DiscoverEndomorphisms.isLessThanSqrt(bigInteger2, bigInteger);
    }

    private static BigInteger[] order(BigInteger bigInteger, BigInteger bigInteger2) {
        if (bigInteger.compareTo(bigInteger2) <= 0) {
            return new BigInteger[]{bigInteger, bigInteger2};
        }
        return new BigInteger[]{bigInteger2, bigInteger};
    }

    private static BigInteger roundQuotient(BigInteger bigInteger, BigInteger bigInteger2) {
        boolean bl = bigInteger.signum() != bigInteger2.signum();
        bigInteger = bigInteger.abs();
        bigInteger2 = bigInteger2.abs();
        BigInteger bigInteger3 = bigInteger.add(bigInteger2.shiftRight(1)).divide(bigInteger2);
        return bl ? bigInteger3.negate() : bigInteger3;
    }

    private static BigInteger solveQuadraticEquation(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
        BigInteger bigInteger4 = bigInteger2.multiply(bigInteger2).subtract(bigInteger3.shiftLeft(2)).mod(bigInteger);
        BigInteger bigInteger5 = new ECFieldElement.Fp(bigInteger, bigInteger4).sqrt().toBigInteger();
        if (!bigInteger5.testBit(0)) {
            bigInteger5 = bigInteger.subtract(bigInteger5);
        }
        return bigInteger5.shiftRight(1);
    }

    private static BigInteger isqrt(BigInteger bigInteger) {
        BigInteger bigInteger2 = bigInteger.shiftRight(bigInteger.bitLength() / 2);
        BigInteger bigInteger3;
        while (!(bigInteger3 = bigInteger2.add(bigInteger.divide(bigInteger2)).shiftRight(1)).equals(bigInteger2)) {
            bigInteger2 = bigInteger3;
        }
        return bigInteger3;
    }

    private static void swap(BigInteger[] bigIntegerArray) {
        BigInteger bigInteger = bigIntegerArray[0];
        bigIntegerArray[0] = bigIntegerArray[1];
        bigIntegerArray[1] = bigInteger;
    }
}

