/*
 * Decompiled with CFR 0.152.
 */
package org.testifyproject.bouncycastle.operator.bc;

import org.testifyproject.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.testifyproject.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.testifyproject.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.testifyproject.bouncycastle.crypto.params.KeyParameter;

class AESUtil {
    AESUtil() {
    }

    static AlgorithmIdentifier determineKeyEncAlg(KeyParameter keyParameter) {
        ASN1ObjectIdentifier aSN1ObjectIdentifier;
        int n = keyParameter.getKey().length * 8;
        if (n == 128) {
            aSN1ObjectIdentifier = NISTObjectIdentifiers.id_aes128_wrap;
        } else if (n == 192) {
            aSN1ObjectIdentifier = NISTObjectIdentifiers.id_aes192_wrap;
        } else if (n == 256) {
            aSN1ObjectIdentifier = NISTObjectIdentifiers.id_aes256_wrap;
        } else {
            throw new IllegalArgumentException("illegal keysize in AES");
        }
        return new AlgorithmIdentifier(aSN1ObjectIdentifier);
    }
}

