/*
 * Decompiled with CFR 0.152.
 */
package org.testifyproject.bouncycastle.operator.bc;

import java.io.IOException;
import org.testifyproject.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.testifyproject.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.testifyproject.bouncycastle.crypto.ExtendedDigest;
import org.testifyproject.bouncycastle.crypto.Signer;
import org.testifyproject.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.testifyproject.bouncycastle.crypto.signers.DSADigestSigner;
import org.testifyproject.bouncycastle.crypto.signers.DSASigner;
import org.testifyproject.bouncycastle.crypto.util.PublicKeyFactory;
import org.testifyproject.bouncycastle.operator.DigestAlgorithmIdentifierFinder;
import org.testifyproject.bouncycastle.operator.OperatorCreationException;
import org.testifyproject.bouncycastle.operator.bc.BcContentVerifierProviderBuilder;

public class BcDSAContentVerifierProviderBuilder
extends BcContentVerifierProviderBuilder {
    private DigestAlgorithmIdentifierFinder digestAlgorithmFinder;

    public BcDSAContentVerifierProviderBuilder(DigestAlgorithmIdentifierFinder digestAlgorithmIdentifierFinder) {
        this.digestAlgorithmFinder = digestAlgorithmIdentifierFinder;
    }

    protected Signer createSigner(AlgorithmIdentifier algorithmIdentifier) throws OperatorCreationException {
        AlgorithmIdentifier algorithmIdentifier2 = this.digestAlgorithmFinder.find(algorithmIdentifier);
        ExtendedDigest extendedDigest = this.digestProvider.get(algorithmIdentifier2);
        return new DSADigestSigner(new DSASigner(), extendedDigest);
    }

    protected AsymmetricKeyParameter extractKeyParameters(SubjectPublicKeyInfo subjectPublicKeyInfo) throws IOException {
        return PublicKeyFactory.createKey(subjectPublicKeyInfo);
    }
}

