/*
 * Decompiled with CFR 0.152.
 */
package org.testifyproject.bouncycastle.pkcs.bc;

import java.io.OutputStream;
import java.security.SecureRandom;
import org.testifyproject.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.testifyproject.bouncycastle.asn1.pkcs.PKCS12PBEParams;
import org.testifyproject.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.testifyproject.bouncycastle.crypto.BlockCipher;
import org.testifyproject.bouncycastle.crypto.BufferedBlockCipher;
import org.testifyproject.bouncycastle.crypto.CipherParameters;
import org.testifyproject.bouncycastle.crypto.ExtendedDigest;
import org.testifyproject.bouncycastle.crypto.digests.SHA1Digest;
import org.testifyproject.bouncycastle.crypto.generators.PKCS12ParametersGenerator;
import org.testifyproject.bouncycastle.crypto.io.CipherOutputStream;
import org.testifyproject.bouncycastle.crypto.paddings.PKCS7Padding;
import org.testifyproject.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import org.testifyproject.bouncycastle.operator.GenericKey;
import org.testifyproject.bouncycastle.operator.OutputEncryptor;
import org.testifyproject.bouncycastle.pkcs.bc.PKCS12PBEUtils;

public class BcPKCS12PBEOutputEncryptorBuilder {
    private ExtendedDigest digest;
    private BufferedBlockCipher engine;
    private ASN1ObjectIdentifier algorithm;
    private SecureRandom random;

    public BcPKCS12PBEOutputEncryptorBuilder(ASN1ObjectIdentifier aSN1ObjectIdentifier, BlockCipher blockCipher) {
        this(aSN1ObjectIdentifier, blockCipher, new SHA1Digest());
    }

    public BcPKCS12PBEOutputEncryptorBuilder(ASN1ObjectIdentifier aSN1ObjectIdentifier, BlockCipher blockCipher, ExtendedDigest extendedDigest) {
        this.algorithm = aSN1ObjectIdentifier;
        this.engine = new PaddedBufferedBlockCipher(blockCipher, new PKCS7Padding());
        this.digest = extendedDigest;
    }

    public OutputEncryptor build(final char[] cArray) {
        if (this.random == null) {
            this.random = new SecureRandom();
        }
        byte[] byArray = new byte[20];
        this.random.nextBytes(byArray);
        final PKCS12PBEParams pKCS12PBEParams = new PKCS12PBEParams(byArray, 1024);
        CipherParameters cipherParameters = PKCS12PBEUtils.createCipherParameters(this.algorithm, this.digest, this.engine.getBlockSize(), pKCS12PBEParams, cArray);
        this.engine.init(true, cipherParameters);
        return new OutputEncryptor(){

            public AlgorithmIdentifier getAlgorithmIdentifier() {
                return new AlgorithmIdentifier(BcPKCS12PBEOutputEncryptorBuilder.this.algorithm, pKCS12PBEParams);
            }

            public OutputStream getOutputStream(OutputStream outputStream) {
                return new CipherOutputStream(outputStream, BcPKCS12PBEOutputEncryptorBuilder.this.engine);
            }

            public GenericKey getKey() {
                return new GenericKey(new AlgorithmIdentifier(BcPKCS12PBEOutputEncryptorBuilder.this.algorithm, pKCS12PBEParams), PKCS12ParametersGenerator.PKCS12PasswordToBytes(cArray));
            }
        };
    }
}

