/*
 * Decompiled with CFR 0.152.
 */
package org.testifyproject.bouncycastle.pkcs.jcajce;

import java.io.OutputStream;
import java.security.Provider;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import org.testifyproject.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.testifyproject.bouncycastle.asn1.DERNull;
import org.testifyproject.bouncycastle.asn1.pkcs.PKCS12PBEParams;
import org.testifyproject.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.testifyproject.bouncycastle.crypto.generators.PKCS12ParametersGenerator;
import org.testifyproject.bouncycastle.jcajce.io.MacOutputStream;
import org.testifyproject.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import org.testifyproject.bouncycastle.jcajce.util.JcaJceHelper;
import org.testifyproject.bouncycastle.jcajce.util.NamedJcaJceHelper;
import org.testifyproject.bouncycastle.jcajce.util.ProviderJcaJceHelper;
import org.testifyproject.bouncycastle.operator.GenericKey;
import org.testifyproject.bouncycastle.operator.MacCalculator;
import org.testifyproject.bouncycastle.operator.OperatorCreationException;
import org.testifyproject.bouncycastle.pkcs.PKCS12MacCalculatorBuilder;
import org.testifyproject.bouncycastle.pkcs.PKCS12MacCalculatorBuilderProvider;

public class JcePKCS12MacCalculatorBuilderProvider
implements PKCS12MacCalculatorBuilderProvider {
    private JcaJceHelper helper = new DefaultJcaJceHelper();

    public JcePKCS12MacCalculatorBuilderProvider setProvider(Provider provider) {
        this.helper = new ProviderJcaJceHelper(provider);
        return this;
    }

    public JcePKCS12MacCalculatorBuilderProvider setProvider(String string) {
        this.helper = new NamedJcaJceHelper(string);
        return this;
    }

    public PKCS12MacCalculatorBuilder get(final AlgorithmIdentifier algorithmIdentifier) {
        return new PKCS12MacCalculatorBuilder(){

            public MacCalculator build(final char[] cArray) throws OperatorCreationException {
                final PKCS12PBEParams pKCS12PBEParams = PKCS12PBEParams.getInstance(algorithmIdentifier.getParameters());
                try {
                    final ASN1ObjectIdentifier aSN1ObjectIdentifier = algorithmIdentifier.getAlgorithm();
                    final Mac mac = JcePKCS12MacCalculatorBuilderProvider.this.helper.createMac(aSN1ObjectIdentifier.getId());
                    SecretKeyFactory secretKeyFactory = JcePKCS12MacCalculatorBuilderProvider.this.helper.createSecretKeyFactory(aSN1ObjectIdentifier.getId());
                    PBEParameterSpec pBEParameterSpec = new PBEParameterSpec(pKCS12PBEParams.getIV(), pKCS12PBEParams.getIterations().intValue());
                    PBEKeySpec pBEKeySpec = new PBEKeySpec(cArray);
                    SecretKey secretKey = secretKeyFactory.generateSecret(pBEKeySpec);
                    mac.init(secretKey, pBEParameterSpec);
                    return new MacCalculator(){

                        public AlgorithmIdentifier getAlgorithmIdentifier() {
                            return new AlgorithmIdentifier(aSN1ObjectIdentifier, pKCS12PBEParams);
                        }

                        public OutputStream getOutputStream() {
                            return new MacOutputStream(mac);
                        }

                        public byte[] getMac() {
                            return mac.doFinal();
                        }

                        public GenericKey getKey() {
                            return new GenericKey(this.getAlgorithmIdentifier(), PKCS12ParametersGenerator.PKCS12PasswordToBytes(cArray));
                        }
                    };
                }
                catch (Exception exception) {
                    throw new OperatorCreationException("unable to create MAC calculator: " + exception.getMessage(), exception);
                }
            }

            public AlgorithmIdentifier getDigestAlgorithmIdentifier() {
                return new AlgorithmIdentifier(algorithmIdentifier.getAlgorithm(), DERNull.INSTANCE);
            }
        };
    }
}

