/*
 * Decompiled with CFR 0.152.
 */
package org.testifyproject.bytecode.annotation;

import java.io.IOException;
import java.lang.reflect.Method;
import org.testifyproject.ClassPool;
import org.testifyproject.bytecode.ConstPool;
import org.testifyproject.bytecode.Descriptor;
import org.testifyproject.bytecode.annotation.AnnotationsWriter;
import org.testifyproject.bytecode.annotation.MemberValueVisitor;
import org.testifyproject.bytecode.annotation.NoSuchClassError;

public abstract class MemberValue {
    ConstPool cp;
    char tag;

    MemberValue(char tag, ConstPool cp) {
        this.cp = cp;
        this.tag = tag;
    }

    abstract Object getValue(ClassLoader var1, ClassPool var2, Method var3) throws ClassNotFoundException;

    abstract Class getType(ClassLoader var1) throws ClassNotFoundException;

    static Class loadClass(ClassLoader cl, String classname) throws ClassNotFoundException, NoSuchClassError {
        try {
            return Class.forName(MemberValue.convertFromArray(classname), true, cl);
        }
        catch (LinkageError e) {
            throw new NoSuchClassError(classname, e);
        }
    }

    private static String convertFromArray(String classname) {
        int index = classname.indexOf("[]");
        if (index != -1) {
            String rawType = classname.substring(0, index);
            StringBuffer sb = new StringBuffer(Descriptor.of(rawType));
            while (index != -1) {
                sb.insert(0, "[");
                index = classname.indexOf("[]", index + 1);
            }
            return sb.toString().replace('/', '.');
        }
        return classname;
    }

    public abstract void accept(MemberValueVisitor var1);

    public abstract void write(AnnotationsWriter var1) throws IOException;
}

