/*
 * Decompiled with CFR 0.152.
 */
package org.testifyproject.github.dockerjava.api.model;

import java.io.IOException;
import org.testifyproject.apache.commons.lang.builder.EqualsBuilder;
import org.testifyproject.apache.commons.lang.builder.HashCodeBuilder;
import org.testifyproject.fasterxml.jackson.core.JsonGenerator;
import org.testifyproject.fasterxml.jackson.core.JsonParser;
import org.testifyproject.fasterxml.jackson.core.JsonProcessingException;
import org.testifyproject.fasterxml.jackson.core.ObjectCodec;
import org.testifyproject.fasterxml.jackson.databind.DeserializationContext;
import org.testifyproject.fasterxml.jackson.databind.JsonDeserializer;
import org.testifyproject.fasterxml.jackson.databind.JsonNode;
import org.testifyproject.fasterxml.jackson.databind.JsonSerializer;
import org.testifyproject.fasterxml.jackson.databind.SerializerProvider;
import org.testifyproject.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.testifyproject.fasterxml.jackson.databind.annotation.JsonSerialize;
import org.testifyproject.github.dockerjava.api.model.AccessMode;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public class VolumesFrom {
    private String container;
    private AccessMode accessMode;

    public VolumesFrom(String container) {
        this(container, AccessMode.DEFAULT);
    }

    public VolumesFrom(String container, AccessMode accessMode) {
        this.container = container;
        this.accessMode = accessMode;
    }

    public String getContainer() {
        return this.container;
    }

    public AccessMode getAccessMode() {
        return this.accessMode;
    }

    public static VolumesFrom parse(String serialized) {
        try {
            String[] parts = serialized.split(":");
            switch (parts.length) {
                case 1: {
                    return new VolumesFrom(parts[0]);
                }
                case 2: {
                    return new VolumesFrom(parts[0], AccessMode.valueOf(parts[1]));
                }
            }
            throw new IllegalArgumentException();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error parsing Bind '" + serialized + "'");
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof VolumesFrom) {
            VolumesFrom other = (VolumesFrom)obj;
            return new EqualsBuilder().append(this.container, other.getContainer()).append((Object)this.accessMode, (Object)other.getAccessMode()).isEquals();
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.container).append((Object)this.accessMode).toHashCode();
    }

    public String toString() {
        return this.container + ":" + this.accessMode.toString();
    }

    public static class Deserializer
    extends JsonDeserializer<VolumesFrom> {
        @Override
        public VolumesFrom deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            ObjectCodec oc = jsonParser.getCodec();
            JsonNode node = (JsonNode)oc.readTree(jsonParser);
            return VolumesFrom.parse(node.asText());
        }
    }

    public static class Serializer
    extends JsonSerializer<VolumesFrom> {
        @Override
        public void serialize(VolumesFrom volumeFrom, JsonGenerator jsonGen, SerializerProvider serProvider) throws IOException, JsonProcessingException {
            jsonGen.writeString(volumeFrom.toString());
        }
    }
}

