/*
 * Decompiled with CFR 0.152.
 */
package org.testifyproject.github.dockerjava.core.command;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.testifyproject.github.dockerjava.api.command.BuildImageCmd;
import org.testifyproject.github.dockerjava.api.model.AuthConfigurations;
import org.testifyproject.github.dockerjava.api.model.BuildResponseItem;
import org.testifyproject.github.dockerjava.core.command.AbstrAsyncDockerCmd;
import org.testifyproject.github.dockerjava.core.dockerfile.Dockerfile;
import org.testifyproject.github.dockerjava.core.util.FilePathUtil;
import org.testifyproject.google.common.base.Preconditions;

public class BuildImageCmdImpl
extends AbstrAsyncDockerCmd<BuildImageCmd, BuildResponseItem>
implements BuildImageCmd {
    private InputStream tarInputStream;
    private String tag;
    private Boolean noCache;
    private Boolean remove = true;
    private Boolean quiet;
    private Boolean pull;
    private AuthConfigurations buildAuthConfigs;
    private File dockerFile;
    private File baseDirectory;
    private String cpusetcpus;
    private Long memory;
    private String cpushares;
    private Boolean forcerm;
    private Long memswap;
    private Long shmsize;
    private URI remote;
    private Map<String, String> buildArgs;

    public BuildImageCmdImpl(BuildImageCmd.Exec exec) {
        super(exec);
    }

    public BuildImageCmdImpl(BuildImageCmd.Exec exec, File dockerFileOrFolder) {
        super(exec);
        Preconditions.checkNotNull(dockerFileOrFolder, "dockerFolder is null");
        if (dockerFileOrFolder.isDirectory()) {
            this.withBaseDirectory(dockerFileOrFolder);
            this.withDockerfile(new File(dockerFileOrFolder, "Dockerfile"));
        } else {
            this.withDockerfile(dockerFileOrFolder);
        }
    }

    public BuildImageCmdImpl(BuildImageCmd.Exec exec, InputStream tarInputStream) {
        super(exec);
        Preconditions.checkNotNull(tarInputStream, "tarInputStream is null");
        this.withTarInputStream(tarInputStream);
    }

    @Override
    public String getTag() {
        return this.tag;
    }

    @Override
    public URI getRemote() {
        return this.remote;
    }

    @Override
    public Boolean hasNoCacheEnabled() {
        return this.noCache;
    }

    @Override
    public Boolean hasRemoveEnabled() {
        return this.remove;
    }

    @Override
    public Boolean isForcerm() {
        return this.forcerm;
    }

    @Override
    public Boolean isQuiet() {
        return this.quiet;
    }

    @Override
    public Boolean hasPullEnabled() {
        return this.pull;
    }

    @Override
    public String getPathToDockerfile() {
        if (this.baseDirectory != null && this.dockerFile != null) {
            return FilePathUtil.relativize(this.baseDirectory, this.dockerFile);
        }
        return null;
    }

    @Override
    public Long getMemory() {
        return this.memory;
    }

    @Override
    public Long getMemswap() {
        return this.memswap;
    }

    @Override
    public String getCpushares() {
        return this.cpushares;
    }

    @Override
    public String getCpusetcpus() {
        return this.cpusetcpus;
    }

    @Override
    public Map<String, String> getBuildArgs() {
        return this.buildArgs;
    }

    @Override
    public AuthConfigurations getBuildAuthConfigs() {
        return this.buildAuthConfigs;
    }

    @Override
    public InputStream getTarInputStream() {
        return this.tarInputStream;
    }

    @Override
    public Long getShmsize() {
        return this.shmsize;
    }

    @Override
    public BuildImageCmdImpl withTag(String tag) {
        Preconditions.checkNotNull(tag, "Tag is null");
        this.tag = tag;
        return this;
    }

    @Override
    public BuildImageCmd withRemote(URI remote) {
        this.remote = remote;
        return this;
    }

    @Override
    public BuildImageCmdImpl withNoCache(Boolean noCache) {
        this.noCache = noCache;
        return this;
    }

    @Override
    public BuildImageCmdImpl withRemove(Boolean rm) {
        this.remove = rm;
        return this;
    }

    @Override
    public BuildImageCmd withForcerm(Boolean forcerm) {
        this.forcerm = forcerm;
        return this;
    }

    @Override
    public BuildImageCmdImpl withQuiet(Boolean quiet) {
        this.quiet = quiet;
        return this;
    }

    @Override
    public BuildImageCmdImpl withPull(Boolean pull) {
        this.pull = pull;
        return this;
    }

    @Override
    public BuildImageCmd withMemory(Long memory) {
        this.memory = memory;
        return this;
    }

    @Override
    public BuildImageCmd withMemswap(Long memswap) {
        this.memswap = memswap;
        return this;
    }

    @Override
    public BuildImageCmd withCpushares(String cpushares) {
        this.cpushares = cpushares;
        return this;
    }

    @Override
    public BuildImageCmd withCpusetcpus(String cpusetcpus) {
        this.cpusetcpus = cpusetcpus;
        return this;
    }

    @Override
    public BuildImageCmd withBuildArg(String key, String value) {
        if (this.buildArgs == null) {
            this.buildArgs = new HashMap<String, String>();
        }
        this.buildArgs.put(key, value);
        return this;
    }

    @Override
    public BuildImageCmd withBaseDirectory(File baseDirectory) {
        this.baseDirectory = baseDirectory;
        return this;
    }

    @Override
    public BuildImageCmdImpl withDockerfile(File dockerfile) {
        Preconditions.checkNotNull(dockerfile);
        if (!dockerfile.exists()) {
            throw new IllegalArgumentException("Dockerfile does not exist");
        }
        if (!dockerfile.isFile()) {
            throw new IllegalArgumentException("Not a directory");
        }
        if (this.baseDirectory == null) {
            this.withBaseDirectory(dockerfile.getParentFile());
        }
        this.dockerFile = dockerfile;
        try {
            this.withTarInputStream(new Dockerfile(dockerfile, this.baseDirectory).parse().buildDockerFolderTar());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    @Override
    public BuildImageCmdImpl withTarInputStream(InputStream tarInputStream) {
        Preconditions.checkNotNull(tarInputStream, "tarInputStream is null");
        this.tarInputStream = tarInputStream;
        return this;
    }

    @Override
    public BuildImageCmd withBuildAuthConfigs(AuthConfigurations authConfigs) {
        Preconditions.checkNotNull(authConfigs, "authConfig is null");
        this.buildAuthConfigs = authConfigs;
        return this;
    }

    @Override
    public BuildImageCmd withShmsize(Long shmsize) {
        this.shmsize = shmsize;
        return this;
    }

    @Override
    public void close() {
        super.close();
        try {
            this.tarInputStream.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

