/*
 * Decompiled with CFR 0.152.
 */
package org.testifyproject.github.dockerjava.core.command;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.testifyproject.apache.commons.lang.StringUtils;
import org.testifyproject.apache.commons.lang.builder.ToStringBuilder;
import org.testifyproject.github.dockerjava.api.command.CopyArchiveToContainerCmd;
import org.testifyproject.github.dockerjava.api.exception.DockerClientException;
import org.testifyproject.github.dockerjava.api.exception.NotFoundException;
import org.testifyproject.github.dockerjava.core.command.AbstrDockerCmd;
import org.testifyproject.github.dockerjava.core.util.CompressArchiveUtil;
import org.testifyproject.google.common.base.Preconditions;

public class CopyArchiveToContainerCmdImpl
extends AbstrDockerCmd<CopyArchiveToContainerCmd, Void>
implements CopyArchiveToContainerCmd {
    private String containerId;
    private String remotePath = ".";
    private InputStream tarInputStream;
    private String hostResource;
    private boolean noOverwriteDirNonDir = false;
    private boolean dirChildrenOnly = false;

    public CopyArchiveToContainerCmdImpl(CopyArchiveToContainerCmd.Exec exec, String containerId) {
        super(exec);
        this.withContainerId(containerId);
    }

    @Override
    public CopyArchiveToContainerCmd withContainerId(String containerId) {
        Preconditions.checkNotNull(containerId, "containerId was not specified");
        this.containerId = containerId;
        return this;
    }

    @Override
    public CopyArchiveToContainerCmd withHostResource(String hostResource) {
        Preconditions.checkNotNull(hostResource, "hostResource was not specified");
        this.hostResource = hostResource;
        return this;
    }

    @Override
    public CopyArchiveToContainerCmd withNoOverwriteDirNonDir(boolean noOverwriteDirNonDir) {
        this.noOverwriteDirNonDir = noOverwriteDirNonDir;
        return this;
    }

    @Override
    public CopyArchiveToContainerCmd withRemotePath(String remotePath) {
        Preconditions.checkNotNull(remotePath, "remotePath was not specified");
        this.remotePath = remotePath;
        return this;
    }

    @Override
    public CopyArchiveToContainerCmd withTarInputStream(InputStream tarInputStream) {
        Preconditions.checkNotNull(tarInputStream, "tarInputStream was not specified");
        this.tarInputStream = tarInputStream;
        return this;
    }

    @Override
    public CopyArchiveToContainerCmd withDirChildrenOnly(boolean dirChildrenOnly) {
        this.dirChildrenOnly = dirChildrenOnly;
        return this;
    }

    @Override
    public InputStream getTarInputStream() {
        return this.tarInputStream;
    }

    @Override
    public String getContainerId() {
        return this.containerId;
    }

    @Override
    public String getHostResource() {
        return this.hostResource;
    }

    @Override
    public boolean isNoOverwriteDirNonDir() {
        return this.noOverwriteDirNonDir;
    }

    @Override
    public String getRemotePath() {
        return this.remotePath;
    }

    @Override
    public boolean isDirChildrenOnly() {
        return this.dirChildrenOnly;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this).append("cp ").append(this.hostResource).append(" ").append(this.containerId).append(":").append(this.remotePath).toString();
    }

    private InputStream buildUploadStream(String hostResource, boolean dirChildrenOnly) throws IOException {
        Path toUpload = Files.createTempFile("docker-java", ".tar.gz", new FileAttribute[0]);
        CompressArchiveUtil.tar(Paths.get(hostResource, new String[0]), toUpload, true, dirChildrenOnly);
        return Files.newInputStream(toUpload, new OpenOption[0]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Void exec() throws NotFoundException {
        if (!StringUtils.isNotEmpty(this.hostResource)) {
            if (this.tarInputStream != null) return (Void)super.exec();
            throw new DockerClientException("One of host resource or tar input stream must be defined to perform the copy");
        }
        if (this.tarInputStream != null) {
            throw new DockerClientException("Only one of host resource or tar input stream should be defined to perform the copy, not both");
        }
        try (InputStream uploadStream = this.buildUploadStream(this.hostResource, this.dirChildrenOnly);){
            this.tarInputStream = uploadStream;
            Void void_ = (Void)super.exec();
            return void_;
        }
        catch (IOException e) {
            throw new DockerClientException("Unable to perform tar on host resource " + this.hostResource, e);
        }
    }
}

