/*
 * Decompiled with CFR 0.152.
 */
package org.testifyproject.github.dockerjava.core.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import org.testifyproject.github.dockerjava.api.exception.DockerClientException;

public class FilePathUtil {
    private FilePathUtil() {
    }

    public static String relativize(File baseDir, File file) {
        try {
            baseDir = baseDir.getCanonicalFile();
            file = file.getCanonicalFile();
            return baseDir.toURI().relativize(file.toURI()).getPath();
        }
        catch (IOException e) {
            throw new DockerClientException(e.getMessage(), e);
        }
    }

    public static String relativize(Path baseDir, Path file) {
        String path = baseDir.toUri().relativize(file.toUri()).getPath();
        if (!"/".equals(baseDir.getFileSystem().getSeparator())) {
            return path.replace(baseDir.getFileSystem().getSeparator(), "/");
        }
        return path;
    }
}

