/*
 * Decompiled with CFR 0.152.
 */
package org.testifyproject.github.dockerjava.jaxrs;

import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testifyproject.github.dockerjava.api.command.AuthCmd;
import org.testifyproject.github.dockerjava.api.exception.UnauthorizedException;
import org.testifyproject.github.dockerjava.api.model.AuthResponse;
import org.testifyproject.github.dockerjava.core.DockerClientConfig;
import org.testifyproject.github.dockerjava.jaxrs.AbstrSyncDockerCmdExec;

public class AuthCmdExec
extends AbstrSyncDockerCmdExec<AuthCmd, AuthResponse>
implements AuthCmd.Exec {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthCmdExec.class);

    public AuthCmdExec(WebTarget baseResource, DockerClientConfig dockerClientConfig) {
        super(baseResource, dockerClientConfig);
    }

    @Override
    protected AuthResponse execute(AuthCmd command) {
        WebTarget webResource = this.getBaseResource().path("/auth");
        LOGGER.trace("POST: {}", (Object)webResource);
        Response response = webResource.request().accept("application/json").post(Entity.entity(command.getAuthConfig(), "application/json"));
        if (response.getStatus() == 401) {
            throw new UnauthorizedException("Unauthorized");
        }
        return response.readEntity(AuthResponse.class);
    }
}

