/*
 * Decompiled with CFR 0.152.
 */
package org.testifyproject.github.dockerjava.jaxrs;

import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testifyproject.github.dockerjava.api.async.ResultCallback;
import org.testifyproject.github.dockerjava.api.command.PushImageCmd;
import org.testifyproject.github.dockerjava.api.model.AuthConfig;
import org.testifyproject.github.dockerjava.api.model.PushResponseItem;
import org.testifyproject.github.dockerjava.core.DockerClientConfig;
import org.testifyproject.github.dockerjava.core.async.JsonStreamProcessor;
import org.testifyproject.github.dockerjava.jaxrs.AbstrAsyncDockerCmdExec;
import org.testifyproject.github.dockerjava.jaxrs.async.AbstractCallbackNotifier;
import org.testifyproject.github.dockerjava.jaxrs.async.POSTCallbackNotifier;

public class PushImageCmdExec
extends AbstrAsyncDockerCmdExec<PushImageCmd, PushResponseItem>
implements PushImageCmd.Exec {
    private static final Logger LOGGER = LoggerFactory.getLogger(PushImageCmdExec.class);

    public PushImageCmdExec(WebTarget baseResource, DockerClientConfig dockerClientConfig) {
        super(baseResource, dockerClientConfig);
    }

    private String name(PushImageCmd command) {
        String name = command.getName();
        AuthConfig authConfig = command.getAuthConfig();
        return name.contains("/") || authConfig == null ? name : authConfig.getUsername();
    }

    @Override
    protected AbstractCallbackNotifier<PushResponseItem> callbackNotifier(PushImageCmd command, ResultCallback<PushResponseItem> resultCallback) {
        WebTarget webResource = this.getBaseResource().path("/images/" + this.name(command) + "/push").queryParam("tag", command.getTag());
        String registryAuth = this.registryAuth(command.getAuthConfig());
        LOGGER.trace("POST: {}", (Object)webResource);
        Invocation.Builder builder = webResource.request().header("X-Registry-Auth", registryAuth).accept("application/json");
        return new POSTCallbackNotifier<PushResponseItem>(new JsonStreamProcessor<PushResponseItem>(PushResponseItem.class), resultCallback, builder, Entity.entity(null, "application/json"));
    }
}

